/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.bizorder;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.ConverterToItemEntity;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.request.BillItemSummaryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryItemsByMainIdsAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillItemClient itemClient;
    @Autowired
    private ConverterToItemEntity converterItem;

    public Object process(AdapterParams adapterParams) {
        Response response;
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Object mainIds = params.get("mainIds");
        Object status = params.get("status");
        BillItemSummaryRequest request = new BillItemSummaryRequest();
        request.setBillIds((List)mainIds);
        if (Objects.nonNull(status)) {
            request.setStatus((List)status);
        }
        ArrayList billItems = Lists.newArrayList();
        while (!CollectionUtils.isEmpty((Collection)((Collection)(response = this.itemClient.queryByPage(tenantId, request)).getResult()))) {
            List result = (List)response.getResult();
            billItems.addAll(result);
            request.setItemId(((BillItem)result.get(result.size() - 1)).getId());
        }
        return this.converterItem.mapToItemVoList(billItems);
    }

    public String adapterName() {
        return "queryItemsByMainIds";
    }
}

