/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.bizorder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.ConverterToMainEntity;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.enums.SalesBillStatus;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryOrderForBurgerKingAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillEsSearchClient esSearchClient;
    @Autowired
    private ConverterToMainEntity converterMain;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        String orderNo = (String)params.get("orderNo");
        Long sellerGroupId = (Long)params.get("sellerGroupId");
        Map paramMap = Maps.newHashMap();
        if (Objects.nonNull(params.get("params"))) {
            paramMap = (Map)params.get("params");
        }
        String orderCreateTime = (String)paramMap.get("orderCreateTime");
        String amountWithTax = (String)paramMap.get("amountWithTax");
        String storeNo = (String)paramMap.get("storeNo");
        ArrayList groups = Lists.newArrayList();
        ArrayList searchFilters = Lists.newArrayList();
        String[] split = orderNo.split("\\^");
        StringBuilder builder = new StringBuilder();
        if (split.length == 1) {
            StringBuilder stringBuilder = builder = StringUtils.isEmpty((CharSequence)storeNo) ? builder.append(orderNo) : builder.append(storeNo).append("^").append(orderNo);
            if (StringUtils.isNotEmpty((CharSequence)orderCreateTime)) {
                builder.append("^").append(orderCreateTime);
            }
        } else if (split.length == 2 || split.length == 3) {
            builder.append(orderNo);
        } else {
            builder.append(split[0]).append("^").append(split[1]).append("^").append(split[2]);
        }
        searchFilters.add(new SearchFilter("billNo", (List)Lists.newArrayList((Object[])new String[]{builder.toString()}), Operator.like));
        if (split.length == 4 && NumberUtils.isParsable((String)split[3])) {
            searchFilters.add(new SearchFilter("amountWithTax", (List)Lists.newArrayList((Object[])new String[]{split[3]}), Operator.eq));
        } else if (NumberUtils.isParsable((String)amountWithTax)) {
            searchFilters.add(new SearchFilter("amountWithTax", (List)Lists.newArrayList((Object[])new String[]{amountWithTax}), Operator.eq));
        }
        searchFilters.add(new SearchFilter("sellerGroupId", (List)Lists.newArrayList((Object[])new Long[]{sellerGroupId}), Operator.eq));
        searchFilters.add(new SearchFilter("status", (List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.NORMAL.value()}), Operator.eq));
        groups.add(searchFilters);
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setPageNo(Integer.valueOf(1));
        searchRequest.setPageSize(Integer.valueOf(10000));
        searchRequest.setGroups((List)groups);
        request.setSearchModel(searchRequest);
        Response response = this.esSearchClient.billMainElasticSearch(tenantId, request);
        return this.converterMain.converterToList(((ResPageList)response.getResult()).getList());
    }

    public String adapterName() {
        return "queryOrderForBurgerKing";
    }
}

