/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.model.MainMapping;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.vo.ReceiptSearchSort;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.BillIdQueryRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BIllMergeQueryMainNewAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BIllMergeQueryMainNewAdapter.class);
    @Autowired
    private BillEsSearchClient billEsSearchClient;
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Autowired
    private OrdSalesbillVoMapper ordSalesbillVoMapper;
    @Value(value="${bill.split.handle.query.switch:true}")
    private boolean handleQuerySwitch;

    public Object process(AdapterParams adapterParams) {
        List mainIds;
        SearchModel searchModel = (SearchModel)adapterParams.getParams().get("billSearch");
        List mainField = (List)adapterParams.getParams().get("mainField");
        if (Objects.nonNull(searchModel.getSort())) {
            BillGetBillListOptimizeAdapter.mappingMainSortField(searchModel.getSort());
        }
        ReceiptSearchSort searchSort = BillGetBillListOptimizeAdapter.initSearchSorts(searchModel.getSort());
        if (searchModel.getChildGroups().stream().noneMatch(r -> r.stream().anyMatch(t -> !"status".equals(t.getFieldName()) && !"salesbillId".equals(t.getFieldName()) && !"salesbillItemId".equals(t.getFieldName()))) && this.handleQuerySwitch && searchModel.getChildGroups().stream().allMatch(r -> r.stream().anyMatch(t -> "salesbillId".equals(t.getFieldName()) && t.getFieldQueryType() != Operator.not_in)) && CollectionUtils.isNotEmpty(mainIds = searchModel.getChildGroups().stream().flatMap(r -> r.stream().filter(t -> "salesbillId".equals(t.getFieldName())).map(t -> t.getValue()).flatMap(Collection::stream)).map(String::valueOf).filter(StringUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toList()))) {
            BillIdQueryRequest billIdQueryRequest = new BillIdQueryRequest();
            billIdQueryRequest.setMainIds(mainIds);
            if (Objects.nonNull(searchSort)) {
                List searchSorts = CollectionUtils.isEmpty((Collection)searchSort.getSearchSort()) ? Lists.newArrayList((Object[])new ReceiptSearchSort[]{searchSort}) : searchSort.getSearchSort();
                billIdQueryRequest.setSearchSorts(searchSorts);
            }
            Response response = this.mainClient.queryBillsByIds(adapterParams.getTenantId(), billIdQueryRequest);
            return new ResPageList((long)((List)response.getResult()).size(), this.ordSalesbillVoMapper.mapToBillVos((List)response.getResult()));
        }
        SearchModelUtil.mapFields((SearchModel)searchModel);
        log.info("bIllMergeQueryMainNewAdapterSearch:{},searchModelMapper:{}", (Object)JsonUtils.serialize((Object)searchModel), (Object)JsonUtils.serialize((Object)this.searchModelMapper));
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest searchRequest = this.searchModelMapper.mapToSearchRequest(searchModel);
        request.setSearchModel(searchRequest);
        request.getSearchModel().setSearchSort(searchSort);
        request.getSearchModel().setIncludes(mainField.stream().map(MainMapping::getField).collect(Collectors.toList()));
        Response response = this.billEsSearchClient.billMainElasticSearch(adapterParams.getTenantId(), request);
        if (response.isOk()) {
            ResPageList pageList = (ResPageList)response.getResult();
            List billMains = pageList.getList();
            return new ResPageList(pageList.getTotal(), this.ordSalesbillVoMapper.mapToBillVos(billMains));
        }
        return new ResPageList(0L, (List)Lists.newArrayList());
    }

    public String adapterName() {
        return "getOrdSalesbillVOSNew";
    }
}

