/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillMainMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.model.BillPageCountResult;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.BillStatisticsRequest;
import com.xforceplus.phoenix.bill.client.model.Exclude;
import com.xforceplus.phoenix.bill.client.model.Include;
import com.xforceplus.phoenix.bill.client.model.SelectedBizorderStatistics;
import com.xforceplus.phoenix.esutils.EsPageQueryUtils;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.enums.FieldSource;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.enums.AggregationTypeEnum;
import com.xforceplus.receipt.vo.BillItemAggResult;
import com.xforceplus.receipt.vo.BillMainCount;
import com.xforceplus.receipt.vo.request.AggregationCondition;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillCountSelectedBillAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillCountSelectedBillAdapter.class);
    @Autowired
    private BillAdapterService adapterService;
    @Autowired
    private BillEsSearchClient esSearchClient;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Autowired
    private BillMainMapper billMainMapper;
    private static final String SALES_BILL_ID_FIELD = "salesbillId";
    private static final String SALES_BILL_ITEM_ID_FIELD = "salesbillItemId";

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        BillSearchModel billSearchModel = (BillSearchModel)params.get("billSearchModel");
        BillStatisticsRequest statisticsRequest = (BillStatisticsRequest)params.get("request");
        log.info("statisticsRequest:{}", (Object)JsonUtils.serialize((Object)statisticsRequest));
        SearchModel searchModel = this.adapterService.buildHasSearchModelForAdapter(billSearchModel);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        request.setSearchModel(this.searchModelMapper.mapToSearchRequest(searchModel));
        Response response = this.esSearchClient.billElasticNewSearchCount(tenantId, request);
        List childGroups = searchModel.getChildGroups();
        if (response.isOk()) {
            SelectedBizorderStatistics statistics = new SelectedBizorderStatistics();
            BillPageCountResult countResult = this.billMainMapper.convert((BillMainCount)response.getResult());
            statistics.setAllStatistics(countResult);
            List<List<SearchFilter>> filterGroups = this.buildSelectedGroup(statisticsRequest);
            if (Objects.isNull(childGroups) || org.springframework.util.CollectionUtils.isEmpty((Collection)childGroups)) {
                childGroups = Lists.newArrayList();
            }
            childGroups = EsPageQueryUtils.mergeGroups((List)childGroups, filterGroups);
            searchModel.setChildGroups(childGroups);
            SearchModelUtil.mapFields((SearchModel)searchModel);
            request.setSearchModel(this.searchModelMapper.mapToSearchRequest(searchModel));
            List<AggregationCondition> aggregationConditions = this.buildAggregationConditions();
            request.getSearchModel().setAggregationConditions(aggregationConditions);
            Response itemAggResultResponse = this.esSearchClient.billItemAggElasticsearch(tenantId, request);
            BillPageCountResult billPageCountResult = new BillPageCountResult();
            if (itemAggResultResponse.isOk()) {
                List ids;
                BillItemAggResult result = (BillItemAggResult)itemAggResultResponse.getResult();
                Map aggregationMap = result.getAggregations();
                HashMap map = Maps.newHashMap();
                for (Map.Entry entry : aggregationMap.entrySet()) {
                    Map parse = (Map)JsonUtils.parse((String)JsonUtils.serialize(entry.getValue()), Map.class);
                    map.put(entry.getKey(), parse.get("value"));
                }
                Long totalBillCount = countResult.getTotalBillCount();
                if (statisticsRequest.getIsAllSelected().booleanValue()) {
                    List excludes = statisticsRequest.getExcludes();
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)excludes)) {
                        ids = excludes.stream().map(i -> i.getSalesbillId()).collect(Collectors.toList());
                        totalBillCount = totalBillCount - (long)ids.size();
                    }
                } else {
                    List includes = statisticsRequest.getIncludes();
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)includes)) {
                        ids = includes.stream().map(i -> i.getSalesbillId()).collect(Collectors.toList());
                        totalBillCount = ids.size();
                    }
                }
                billPageCountResult.setTotalBillCount(totalBillCount);
                billPageCountResult.setTotal(countResult.getTotalBillCount().longValue());
                billPageCountResult.setTotalDetailsCount(result.getTotal());
                billPageCountResult.setTotalAmountWithTax(new BigDecimal(map.get("amountWithTax").toString()));
                billPageCountResult.setTotalAmountWithoutTax(new BigDecimal(map.get("amountWithoutTax").toString()));
                billPageCountResult.setDiscountWithTaxTotal(new BigDecimal(map.get("outerDiscountWithTax").toString()).add(new BigDecimal(map.get("innerDiscountWithTax").toString())));
                billPageCountResult.setDiscountWithoutTaxTotal(new BigDecimal(map.get("outerDiscountWithoutTax").toString()).add(new BigDecimal(map.get("innerDiscountWithoutTax").toString())));
                billPageCountResult.setUnMakeAmountWithoutTaxTotal(new BigDecimal(map.get("amountWithoutTax").toString()).subtract(new BigDecimal(map.get("outerDiscountWithoutTax").toString())).subtract(new BigDecimal(map.get("innerDiscountWithoutTax").toString())).subtract(new BigDecimal(map.get("alreadyAmountWithoutTax").toString())).subtract(new BigDecimal(map.get("freezeAmountWithoutTax").toString())));
                billPageCountResult.setUnMakeAmountWithTaxTotal(new BigDecimal(map.get("amountWithTax").toString()).subtract(new BigDecimal(map.get("outerDiscountWithTax").toString())).subtract(new BigDecimal(map.get("innerDiscountWithTax").toString())).subtract(new BigDecimal(map.get("alreadyAmountWithTax").toString())).subtract(new BigDecimal(map.get("freezeAmountWithTax").toString())));
            }
            statistics.setSelectedStatistics(billPageCountResult);
            return com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage(), (Object)statistics);
        }
        return Response.failed((String)response.getMessage());
    }

    private List<AggregationCondition> buildAggregationConditions() {
        AggregationCondition outDiscount = new AggregationCondition();
        outDiscount.setAggregationTypeEnum(AggregationTypeEnum.sum);
        outDiscount.setKey("outerDiscountWithTax");
        outDiscount.setFiled("outer_discount_with_tax");
        AggregationCondition outDiscountOut = new AggregationCondition();
        outDiscountOut.setAggregationTypeEnum(AggregationTypeEnum.sum);
        outDiscountOut.setKey("outerDiscountWithoutTax");
        outDiscountOut.setFiled("outer_discount_without_tax");
        AggregationCondition innerDiscount = new AggregationCondition();
        innerDiscount.setAggregationTypeEnum(AggregationTypeEnum.sum);
        innerDiscount.setKey("innerDiscountWithTax");
        innerDiscount.setFiled("inner_discount_with_tax");
        AggregationCondition innerDiscountOut = new AggregationCondition();
        innerDiscountOut.setAggregationTypeEnum(AggregationTypeEnum.sum);
        innerDiscountOut.setKey("innerDiscountWithoutTax");
        innerDiscountOut.setFiled("inner_discount_without_tax");
        AggregationCondition alreadyAmount = new AggregationCondition();
        alreadyAmount.setAggregationTypeEnum(AggregationTypeEnum.sum);
        alreadyAmount.setKey("alreadyAmountWithTax");
        alreadyAmount.setFiled("already_amount_with_tax");
        AggregationCondition alreadyAmountOut = new AggregationCondition();
        alreadyAmountOut.setAggregationTypeEnum(AggregationTypeEnum.sum);
        alreadyAmountOut.setKey("alreadyAmountWithoutTax");
        alreadyAmountOut.setFiled("already_amount_without_tax");
        AggregationCondition freezeAmount = new AggregationCondition();
        freezeAmount.setAggregationTypeEnum(AggregationTypeEnum.sum);
        freezeAmount.setKey("freezeAmountWithTax");
        freezeAmount.setFiled("freeze_amount_with_tax");
        AggregationCondition freezeAmountOut = new AggregationCondition();
        freezeAmountOut.setAggregationTypeEnum(AggregationTypeEnum.sum);
        freezeAmountOut.setKey("freezeAmountWithoutTax");
        freezeAmountOut.setFiled("freeze_amount_without_tax");
        AggregationCondition amount = new AggregationCondition();
        amount.setAggregationTypeEnum(AggregationTypeEnum.sum);
        amount.setKey("amountWithTax");
        amount.setFiled("amount_with_tax");
        AggregationCondition amountOut = new AggregationCondition();
        amountOut.setAggregationTypeEnum(AggregationTypeEnum.sum);
        amountOut.setKey("amountWithoutTax");
        amountOut.setFiled("amount_without_tax");
        return Arrays.asList(outDiscount, outDiscountOut, innerDiscount, innerDiscountOut, alreadyAmount, alreadyAmountOut, freezeAmount, freezeAmountOut, amount, amountOut);
    }

    public String adapterName() {
        return "countSelectedBill";
    }

    private List<List<SearchFilter>> buildSelectedGroup(BillStatisticsRequest request) {
        ArrayList groups = Lists.newArrayList();
        boolean isAllSelected = request.getIsAllSelected();
        if (isAllSelected) {
            List salesbill;
            List excludes = request.getExcludes();
            List hasSalesbillItem = excludes.stream().filter(exclude -> !org.springframework.util.CollectionUtils.isEmpty((Collection)exclude.getExcludes()) || !org.springframework.util.CollectionUtils.isEmpty((Collection)exclude.getIncludes())).collect(Collectors.toList());
            if (!org.springframework.util.CollectionUtils.isEmpty(hasSalesbillItem)) {
                for (Exclude exclude2 : hasSalesbillItem) {
                    ArrayList group = Lists.newArrayList();
                    this.fillItemGroup(true, group, exclude2.getIsAllSelected(), exclude2.getSalesbillId(), exclude2.getIncludes(), exclude2.getExcludes());
                    if (org.springframework.util.CollectionUtils.isEmpty((Collection)group)) continue;
                    groups.add(group);
                }
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(salesbill = excludes.stream().filter(exclude -> org.springframework.util.CollectionUtils.isEmpty((Collection)exclude.getExcludes()) && org.springframework.util.CollectionUtils.isEmpty((Collection)exclude.getIncludes())).collect(Collectors.toList()))) {
                SearchFilter searchFilter = new SearchFilter(SALES_BILL_ID_FIELD, salesbill.stream().map(Exclude::getSalesbillId).collect(Collectors.toList()), Operator.not_in);
                groups.add(Lists.newArrayList((Object[])new SearchFilter[]{searchFilter}));
            }
        } else {
            List includes = request.getIncludes();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)includes)) {
                List salesbillMaster;
                ArrayList list = Lists.newArrayList();
                List<Include> hasSalesbillItem = includes.stream().filter(include -> include.getIsAllSelected() == false || include.getIsAllSelected() != false && !org.springframework.util.CollectionUtils.isEmpty((Collection)include.getExcludes())).collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(hasSalesbillItem)) {
                    this.setIncluceFilterGroups(hasSalesbillItem, groups);
                }
                if (!org.springframework.util.CollectionUtils.isEmpty(salesbillMaster = includes.stream().filter(include -> include.getIsAllSelected() != false && org.springframework.util.CollectionUtils.isEmpty((Collection)include.getExcludes())).collect(Collectors.toList()))) {
                    List collect = salesbillMaster.stream().map(Include::getSalesbillId).collect(Collectors.toList());
                    SearchFilter searchFilter = new SearchFilter();
                    searchFilter.setFieldName(SALES_BILL_ID_FIELD);
                    searchFilter.setFieldQueryType(Operator.checkbox);
                    searchFilter.setVirtual(FieldSource.item.value());
                    searchFilter.setValue(collect);
                    list.add(searchFilter);
                    groups.add(list);
                }
            }
        }
        return groups;
    }

    public void setIncluceFilterGroups(List<Include> includeList, List<List<SearchFilter>> outFilterGroups) {
        if (!CollectionUtils.isEmpty(includeList)) {
            for (Include include : includeList) {
                ArrayList group = Lists.newArrayList();
                this.fillItemGroup(false, group, include.getIsAllSelected(), include.getSalesbillId(), include.getIncludes(), include.getExcludes());
                if (CollectionUtils.isEmpty((Collection)group)) continue;
                outFilterGroups.add(group);
            }
        }
    }

    public void fillItemGroup(boolean isAllSelect, List<SearchFilter> group, boolean isAll, String salesbillId, List<String> includes, List<String> excludes) {
        if (isAll) {
            if (!isAllSelect) {
                this.setSearchFilterLongValue(SALES_BILL_ID_FIELD, Lists.newArrayList((Object[])new String[]{salesbillId}), Operator.eq, group, 0);
            }
            if (!CollectionUtils.isEmpty(excludes)) {
                this.setSearchFilterLongValue(SALES_BILL_ITEM_ID_FIELD, excludes, Operator.not_in, group, 1);
            }
        } else if (!CollectionUtils.isEmpty(includes)) {
            this.setSearchFilterLongValue(SALES_BILL_ID_FIELD, Lists.newArrayList((Object[])new String[]{salesbillId}), Operator.eq, group, 0);
            this.setSearchFilterLongValue(SALES_BILL_ITEM_ID_FIELD, includes, Operator.checkbox, group, 1);
        }
    }

    private void setSearchFilterLongValue(String fieldName, List<String> value, Operator operator, List<SearchFilter> group, int fieldGroupIndex) {
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setFieldName(fieldName);
        searchFilter.setFieldQueryType(operator);
        searchFilter.setVirtual(FieldSource.item.value());
        searchFilter.setValue(value);
        searchFilter.setFieldGroupIndex(Integer.valueOf(fieldGroupIndex));
        group.add(searchFilter);
    }
}

