/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillItemInfoMapper;
import com.xforceplus.phoenix.bill.client.model.BillDetailListResponse;
import com.xforceplus.phoenix.bill.client.model.GetBillItemsListRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillDeletedByIdAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private BillItemInfoMapper billItemInfoMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        GetBillItemsListRequest request = (GetBillItemsListRequest)params.get("getBillItemsListRequest");
        Long salesBillId = request.getSalesBillId();
        Response deletedResponse = this.billItemClient.getDeletedByBillId(tenantId, salesBillId);
        BillDetailListResponse response = new BillDetailListResponse();
        if (deletedResponse.isOk()) {
            response.setCode(BillDetailListResponse.OK);
            response.setResult(this.billItemInfoMapper.mapToBillItemInfos((List)deletedResponse.getResult()));
            response.setMessage(deletedResponse.getMessage());
        } else {
            response.setCode(BillDetailListResponse.Fail);
            response.setMessage(deletedResponse.getMessage());
        }
        return response;
    }

    public String adapterName() {
        return "queryDeletedItemsByBillId";
    }
}

