/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillDetailCountAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillEsSearchClient billEsSearchClient;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        SearchModel searchModel = (SearchModel)adapterParams.getParams().get("searchModel");
        SearchModelUtil.mapFields((SearchModel)searchModel);
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest searchRequest = new SearchRequest(searchModel);
        request.setSearchModel(searchRequest);
        Response pageListResponse = this.billEsSearchClient.billElasticSearchItemCount(adapterParams.getTenantId(), request);
        return pageListResponse.isOk() ? ((ResPageList)pageListResponse.getResult()).getTotal() : 0L;
    }

    public String adapterName() {
        return "getBillDetailCount";
    }
}

