/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.component.CommonService;
import com.xforceplus.adapter.component.query.BillGetBillListByDetailOptimizeAdapter;
import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillItemVoMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.model.BillItemResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.vo.ReceiptSearchSort;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.BillItemSummaryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import reactor.util.function.Tuple2;

@Component
public class BillDetailListNewAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillDetailListNewAdapter.class);
    @Autowired
    private BillAdapterService billAdapterService;
    @Autowired
    private BillEsSearchClient esSearchClient;
    @Autowired
    private OrdSalesbillItemVoMapper itemVoMapper;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private CommonService commonService;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        BillSearchModel billSearchModel = (BillSearchModel)params.get("billSearchModel");
        if (billSearchModel.getSort() == null || billSearchModel.getSort().getFieldName() == null) {
            ArrayList sorts = Lists.newArrayList();
            SearchSort sort = new SearchSort();
            sort.setFieldName("itemNo");
            sort.setSort("0");
            sorts.add(sort);
            SearchSort sort1 = new SearchSort();
            sort1.setFieldName("id");
            sort1.setSort("1");
            sorts.add(sort1);
            SearchSort searchSort = new SearchSort();
            searchSort.setSearchSort((List)sorts);
            billSearchModel.setSort(searchSort);
        }
        SearchModel searchModel = this.billAdapterService.buildHasSearchModelForAdapter(billSearchModel);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        if (Objects.nonNull(searchModel.getSort())) {
            BillGetBillListByDetailOptimizeAdapter.mappingItemSortField(searchModel.getSort());
        }
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        request.setRequestSource(Integer.valueOf(billSearchModel.getRequestSource()));
        request.setSearchModel(this.searchModelMapper.mapToSearchRequest(searchModel));
        ReceiptSearchSort searchSort = BillGetBillListOptimizeAdapter.initSearchSorts(searchModel.getSort());
        request.getSearchModel().setSearchSort(searchSort);
        boolean hasDetailCondition = searchModel.getChildGroups().stream().anyMatch(r -> r.stream().anyMatch(t -> !"status".equals(t.getFieldName()) && !"salesbillId".equals(t.getFieldName())));
        if (hasDetailCondition) {
            Response resPageListResponse = this.esSearchClient.billItemElasticSearch(tenantId, request);
            if (!resPageListResponse.isOk()) {
                BillItemResponse.from((Integer)com.xforceplus.xplatframework.model.Response.Fail, (String)resPageListResponse.getMessage(), null);
            }
            ResPageList result = (ResPageList)resPageListResponse.getResult();
            List<Object> results = Lists.newArrayList();
            if (Objects.nonNull(result)) {
                results = result.getList().stream().map(b -> this.itemVoMapper.mapToItemVo(b.getItem())).collect(Collectors.toList());
            }
            ResPageList resPageList = new ResPageList(result.getTotal(), (List)results);
            return BillItemResponse.from((Integer)com.xforceplus.xplatframework.model.Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (ResPageList)resPageList);
        }
        Tuple2<List<Long>, List<Integer>> tupleResult = this.commonService.buildItemConditionOnlyId((List)searchModel.getChildGroups().get(0));
        List bizOrderIdList = (List)tupleResult.getT1();
        List statusList = (List)tupleResult.getT2();
        BillItemSummaryRequest midRequest = new BillItemSummaryRequest();
        midRequest.setBillIds(bizOrderIdList);
        midRequest.setStatus(statusList);
        midRequest.setPage(searchModel.getPageNo());
        midRequest.setSize(searchModel.getPageSize());
        Response listResponse = this.billItemClient.queryByPage(tenantId, midRequest);
        midRequest.setPage(null);
        midRequest.setSize(null);
        Response countResponse = this.billItemClient.countByBillIds(tenantId, midRequest);
        List results = Optional.ofNullable(listResponse.getResult()).map(list -> list.stream().map(this.itemVoMapper::mapToItemVo).collect(Collectors.toList())).orElse(Lists.newArrayList());
        ResPageList resPageList = new ResPageList(((Long)Optional.ofNullable(countResponse.getResult()).orElse(0L)).longValue(), results);
        return BillItemResponse.from((Integer)com.xforceplus.xplatframework.model.Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (ResPageList)resPageList);
    }

    public String adapterName() {
        return "getBillDetailListNew";
    }
}

