/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.InvoiceBillItemMapper;
import com.xforceplus.phoenix.bill.client.model.BillQueryItemResponse;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillItemBatchNoAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillItemBatchNoAdapter.class);
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private InvoiceBillItemMapper invoiceBillItemMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map paramMap = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Object batchNo = paramMap.get("batchNo");
        Response resultResponse = this.billItemClient.queryBillItemByBatchNo(tenantId, Long.valueOf(batchNo.toString()));
        BillQueryItemResponse response = new BillQueryItemResponse();
        response.setResult(this.invoiceBillItemMapper.mapToInvoiceBillItems((List)resultResponse.getResult()));
        response.setCode(BaseResponse.OK);
        return response;
    }

    public String adapterName() {
        return "mainItemListByBatchNo";
    }
}

