/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.UploadBillItemsMapper;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillItemByIdsQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillItemByIdsQueryAdapter.class);
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private UploadBillItemsMapper uploadBillItemsMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        List billItemIds = (List)params.get("salesbillItemIds");
        Response response = this.billItemClient.queryBillItem(tenantId, billItemIds);
        List result = (List)response.getResult();
        return this.uploadBillItemsMapper.mapToUploadBillItemsList(result);
    }

    public String adapterName() {
        return "querySalesbillItemByIds";
    }
}

