/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillSourceClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillSourceRelationshipMapper;
import com.xforceplus.phoenix.bill.client.model.BillSourceResponse;
import com.xforceplus.receipt.vo.request.BillSourceRelQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillQuerySourceByItemIdsAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillSourceClient billSourceClient;
    @Autowired
    private BillSourceRelationshipMapper billSourceMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        List ids = (List)params.get("salesbillItemIdList");
        BillSourceRelQueryRequest relQueryRequest = new BillSourceRelQueryRequest();
        relQueryRequest.setTargetBillIds(ids);
        Response sourceResponse = this.billSourceClient.queryBillSource(adapterParams.getTenantId(), relQueryRequest);
        BillSourceResponse response = new BillSourceResponse();
        if (sourceResponse.isOk()) {
            response.setCode(BillSourceResponse.OK);
            response.setResult(this.billSourceMapper.mapToBillSourceRelationships((List)sourceResponse.getResult()));
        } else {
            response.setCode(BillSourceResponse.Fail);
            response.setMessage(sourceResponse.getMessage());
        }
        return response;
    }

    public String adapterName() {
        return "queryBillSourceByItemIds";
    }
}

