/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SellerBillItemMapper;
import com.xforceplus.phoenix.bill.client.model.SplitBillItemVo;
import com.xforceplus.receipt.enums.BillInnerFlag;
import com.xforceplus.receipt.vo.BillBatchNosRequest;
import com.xforceplus.seller.invoice.client.model.BillItem;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetBillAutoItemReturnMapAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillItemClient itemClient;
    @Autowired
    private SellerBillItemMapper billItemMapper;

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        List autoBatchNos = (List)params.get("autoBatchNos");
        BillBatchNosRequest nosRequest = new BillBatchNosRequest();
        nosRequest.setBatchNos(autoBatchNos);
        nosRequest.setInnerFlag(BillInnerFlag.INNER_DATA);
        List items = (List)this.itemClient.queryItemsByBatchNoAnFlag(tenantId, nosRequest).getResult();
        List<BillItem> billItems = this.billItemMapper.toBillItems(items);
        List billIds = billItems.stream().map(i -> Long.valueOf(i.getSalesbillId())).distinct().collect(Collectors.toList());
        Map<Long, List<BillItem>> collect = billItems.stream().collect(Collectors.groupingBy(k -> k.getBatchNo()));
        return new SplitBillItemVo(collect, billIds);
    }

    public String adapterName() {
        return "getBillAutoItemReturnMap";
    }
}

