/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.receipt.vo.request.BillAbandonRequest;
import com.xforceplus.receipt.vo.request.BillIdQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AfterCancelPreviewPreInvoiceAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(AfterCancelPreviewPreInvoiceAdapter.class);
    @Autowired
    private BillUpdateClient billUpdateClient;
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private RabbitmqService rabbitmqService;
    @Value(value="${receipt.adapter.issued.open:false}")
    private Boolean adapterIssuedOpen;
    @Value(value="${receipt.adapter.cancel-pre-view.abandon:0}")
    private Long compassTenantId;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    public Object process(AdapterParams adapterParams) {
        List batchNoList;
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Response response = this.billUpdateClient.afterPreInvDeleteBillStatus(tenantId, batchNoList = (List)params.get("batchNoList"));
        if (response.isOk()) {
            HashMap map = Maps.newHashMap();
            map.put("groupId", Long.valueOf(tenantId));
            Response idsByBatchNos = this.mainClient.queryBillIdsByBatchNos(tenantId, batchNoList);
            if (!CollectionUtils.isEmpty((Collection)((Collection)idsByBatchNos.getResult())) && this.adapterIssuedOpen.booleanValue()) {
                if (tenantId.equals(String.valueOf(this.compassTenantId))) {
                    List collect;
                    BillIdQueryRequest billIdQueryRequest = new BillIdQueryRequest();
                    billIdQueryRequest.setMainIds((List)idsByBatchNos.getResult());
                    Response mainResponse = this.mainClient.queryBillsByIds(tenantId, billIdQueryRequest);
                    if (!CollectionUtils.isEmpty((Collection)((Collection)mainResponse.getResult())) && !CollectionUtils.isEmpty(collect = ((List)mainResponse.getResult()).stream().filter(r -> Objects.nonNull(r.getExtendJson()) && Objects.nonNull(r.getExtendJson().get("systemOrigType")) && String.valueOf(r.getExtendJson().get("systemOrigType")).equals("2")).collect(Collectors.toList()))) {
                        UserInfo info = (UserInfo)this.userInfoHolder.get();
                        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
                        userInfo.setUserId(Long.valueOf(info.getUserId()));
                        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
                        userInfo.setUserName(info.getUserName());
                        List abandonIds = collect.stream().map(c -> c.getId()).collect(Collectors.toList());
                        BillAbandonRequest abandonRequest = new BillAbandonRequest();
                        abandonRequest.setBillIds(abandonIds);
                        abandonRequest.setUserInfo(userInfo);
                        this.billUpdateClient.abandonBill(tenantId, abandonRequest);
                    }
                }
                this.updateOrderMakeApply((List)idsByBatchNos.getResult(), map);
            }
        }
        return com.xforceplus.xplatframework.model.Response.from((Integer)com.xforceplus.xplatframework.model.Response.OK, (String)response.getMessage());
    }

    public void updateOrderMakeApply(List<Long> billIds, Map<String, Object> map) {
        this.rabbitmqService.send("phoenix_order_make_apply", JsonUtils.serialize(billIds), map);
    }

    public String adapterName() {
        return "afterCancelPreviewPreInvoice";
    }
}

