/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.xforceplus.adapter.core.client.ReceiptBillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.bill.client.model.UpdatePreviewBillItemStatusRequest;
import com.xforceplus.receipt.vo.request.BillSplitInvPreviewRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillUpdatePreviewBillItemAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillUpdatePreviewBillItemAdapter.class);
    @Autowired
    private ReceiptBillUpdateClient billUpdateClient;

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        UpdatePreviewBillItemStatusRequest request = (UpdatePreviewBillItemStatusRequest)adapterParams.getParams().get("request");
        Integer itemStatus = request.getItemStatus();
        List queryDataList = request.getQueryDataList();
        Set batchNos = queryDataList.stream().map(q -> q.getBatchNo()).collect(Collectors.toSet());
        BillSplitInvPreviewRequest preInvRequest = new BillSplitInvPreviewRequest();
        preInvRequest.setBatchNos(new ArrayList(batchNos));
        preInvRequest.setStatus(itemStatus);
        Response response = this.billUpdateClient.splitInvPreview(tenantId, preInvRequest);
        return Optional.empty();
    }

    public String adapterName() {
        return "updatePreviewBillItemStatus";
    }
}

