/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.component.BillMatchInvoiceComponent;
import com.xforceplus.adapter.core.client.BillBackFillClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.NoticeBillMsgMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.phoenix.bill.client.api.adapter.model.BillMatchInvoiceVo;
import com.xforceplus.receipt.enums.InvoiceOperationEnum;
import com.xforceplus.receipt.enums.ReleaseDetailEnum;
import com.xforceplus.receipt.vo.request.InvBackFillRequest;
import com.xforceplus.receipt.vo.request.InvMakeOutBackFillRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.invoice.client.model.NoticeBillMsg;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceCompleteAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceCompleteAdapter.class);
    @Autowired
    private BillBackFillClient backFillClient;
    @Autowired
    private NoticeBillMsgMapper noticeBillMsgMapper;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private BillMatchInvoiceComponent matchInvoiceComponent;
    @Autowired
    private RabbitmqService rabbitmqService;
    @Value(value="${receipt.adapter.issued.open:false}")
    private Boolean adapterIssuedOpen;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        List noticeBillMsgList = JsonUtils.parseList((String)JsonUtils.serialize(params.get("noticeBillMsgList")), NoticeBillMsg.class);
        Map headers = JsonUtils.parseMap((String)JsonUtils.serialize(params.get("headers")));
        UserInfo info = (UserInfo)this.userInfoHolder.get();
        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        InvBackFillRequest request = new InvBackFillRequest();
        List<InvMakeOutBackFillRequest> makeOutBackFillRequests = this.noticeBillMsgMapper.mapToRequests(noticeBillMsgList);
        request.setOperationType(InvoiceOperationEnum.INVOICE_MAKE_OUT);
        request.setReleaseDetailEnum(ReleaseDetailEnum.RELEASE_PRE_INV);
        request.setUserInfo(userInfo);
        request.setBackFillRequests(makeOutBackFillRequests);
        Response response = this.backFillClient.invBackFillBill(tenantId, request);
        List<Object> billIds = Lists.newArrayList();
        ArrayList billMatchInvoiceVoList = Lists.newArrayList();
        for (NoticeBillMsg noticeBillMsg : noticeBillMsgList) {
            Integer invoiceOrigin;
            List<Long> collect = noticeBillMsg.getDetailInfoList().stream().map(d -> d.getSalesBillId()).distinct().collect(Collectors.toList());
            String invoiceCode = noticeBillMsg.getInvoiceCode();
            String invoiceNo = noticeBillMsg.getInvoiceNo();
            Long invoiceId = noticeBillMsg.getInvoiceId();
            List<BillMatchInvoiceVo> billMatchInvoiceVos = this.matchInvoiceComponent.createVo(collect, invoiceId, invoiceNo, invoiceCode, invoiceOrigin = noticeBillMsg.getInvoiceOrigin(), tenantId);
            if (!CollectionUtils.isEmpty(billMatchInvoiceVos)) {
                billMatchInvoiceVoList.addAll(billMatchInvoiceVos);
            }
            billIds.addAll(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)billMatchInvoiceVoList)) {
            this.matchInvoiceComponent.saveBillMatchInvoice(billMatchInvoiceVoList);
        }
        billIds = billIds.stream().distinct().collect(Collectors.toList());
        HashMap map = Maps.newHashMap();
        map.put("groupId", userInfo.getGroupId());
        map.put("userId", userInfo.getUserId());
        map.put("userName", userInfo.getUserName());
        if (this.adapterIssuedOpen.booleanValue()) {
            this.updateOrderMakeApply((List<Long>)billIds, map);
        }
        return null;
    }

    public String adapterName() {
        return "invoiceComplete";
    }

    public void updateOrderMakeApply(List<Long> billIds, Map<String, Object> map) {
        this.rabbitmqService.send("phoenix_order_make_apply", JsonUtils.serialize(billIds), map);
    }
}

