/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.xforceplus.adapter.core.client.ReceiptSalesBillDetailClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.ReceiptBillItemMapper;
import com.xforceplus.adapter.mapstruct.ReceiptBillMainMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.vo.BillConvertItem;
import com.xforceplus.adapter.vo.BillConvertMain;
import com.xforceplus.receipt.vo.request.BillAdapterSyncRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateSalesBillAndItemsAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(UpdateSalesBillAndItemsAdapter.class);
    @Autowired
    private ReceiptSalesBillDetailClient billDetailClient;
    @Autowired
    private ReceiptBillMainMapper mainMapper;
    @Autowired
    private ReceiptBillItemMapper itemMapper;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        Object billMainList = params.get("billMainList");
        Object billItemList = params.get("billItemList");
        Object insertBillItemList = params.get("insertBillItemList");
        List updateMains = JsonUtils.parseList((String)JsonUtils.serialize(billMainList), BillConvertMain.class);
        List updateItems = JsonUtils.parseList((String)JsonUtils.serialize(billItemList), BillConvertItem.class);
        List insetItems = JsonUtils.parseList((String)JsonUtils.serialize(insertBillItemList), BillConvertItem.class);
        String tenantId = adapterParams.getTenantId();
        BillAdapterSyncRequest request = new BillAdapterSyncRequest();
        request.setInsertItems(this.itemMapper.mapToBillItems(insetItems));
        request.setUpdateMains(this.mainMapper.mapToBillMains(updateMains));
        request.setUpdateItems(this.itemMapper.mapToBillItems(updateItems));
        Response response = this.billDetailClient.adapterSyncData(tenantId, request);
        return null;
    }

    public String adapterName() {
        return "updateSalesBillAndItems";
    }
}

