/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.mapstruct;

import com.xforceplus.adapter.enums.BigDecimalUtil;
import com.xforceplus.adapter.enums.PriceMethodTypeEnum;
import com.xforceplus.adapter.mapstruct.annotation.FreezeAmountSourceFieldMapping;
import com.xforceplus.adapter.mapstruct.annotation.FreezeAmountTargetFieldMapping;
import com.xforceplus.adapter.mapstruct.annotation.ItemOuterAmountSourceMapping;
import com.xforceplus.adapter.mapstruct.annotation.ItemOuterAmountTargetMapping;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.BillItemExt;
import java.util.List;
import java.util.Map;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.springframework.util.CollectionUtils;

@Mapper(componentModel="spring")
public interface OrdSalesbillItemVoMapper {
    @ItemOuterAmountSourceMapping
    @Mappings(value={@Mapping(source="itemNo", target="salesbillItemNo"), @Mapping(target="createTime", expression="java(com.xforceplus.adapter.utils.DateUtils.parse(billItem.getCreateTime()))"), @Mapping(target="updateTime", expression="java(com.xforceplus.adapter.utils.DateUtils.parse(billItem.getUpdateTime()))"), @Mapping(target="salesbillItemId", source="id"), @Mapping(target="salesbillId", source="billId"), @Mapping(target="salesbillNo", source="billNo")})
    @FreezeAmountSourceFieldMapping
    public OrdSalesbillItemVO mapToItemVo(BillItem var1);

    @ItemOuterAmountTargetMapping
    @Mappings(value={@Mapping(target="itemNo", source="salesbillItemNo"), @Mapping(target="createTime", expression="java(com.xforceplus.adapter.utils.DateUtils.format(ordSalesbillItemVO.getCreateTime()))"), @Mapping(target="updateTime", expression="java(com.xforceplus.adapter.utils.DateUtils.format(ordSalesbillItemVO.getUpdateTime()))"), @Mapping(source="salesbillItemId", target="id"), @Mapping(source="salesbillId", target="billId"), @Mapping(source="salesbillNo", target="billNo")})
    @FreezeAmountTargetFieldMapping
    public BillItem mapToBillItem(OrdSalesbillItemVO var1);

    public List<BillItem> mapToBillItems(List<OrdSalesbillItemVO> var1);

    public List<OrdSalesbillItemVO> mapToItemVoList(List<BillItem> var1);

    public void update(BillItemExt var1, @MappingTarget OrdSalesbillItemVO var2);

    @AfterMapping
    default public void map(BillItem item, @MappingTarget OrdSalesbillItemVO itemVO) {
        Map extendJson = item.getExtendJson();
        if (!CollectionUtils.isEmpty((Map)extendJson)) {
            BillItemExt itemExt = (BillItemExt)JsonUtils.parse((String)JsonUtils.serialize((Object)extendJson), BillItemExt.class);
            this.update(itemExt, itemVO);
        }
        itemVO.setUnMakeAmountWithoutTax(BigDecimalUtil.queryDetailAllowIssueAmount(itemVO, PriceMethodTypeEnum.WITHOUT_PRICE));
        itemVO.setUnMakeAmountWithTax(BigDecimalUtil.queryDetailAllowIssueAmount(itemVO, PriceMethodTypeEnum.WITH_PRICE));
    }
}

