/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.mapstruct;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.mapstruct.annotation.FreezeAmountTargetFieldMapping;
import com.xforceplus.adapter.mapstruct.annotation.ItemOuterAmountTargetMapping;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.vo.BillConvertItem;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.BillItemExt;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.springframework.util.CollectionUtils;

@Mapper(componentModel="spring")
public interface ReceiptBillItemMapper {
    @ItemOuterAmountTargetMapping
    @Mappings(value={@Mapping(source="salesbillItemId", target="id"), @Mapping(source="salesbillItemNo", target="itemNo"), @Mapping(source="salesbillId", target="billId"), @Mapping(source="salesbillNo", target="billNo"), @Mapping(target="createTime", expression="java(com.xforceplus.adapter.utils.DateUtils.format(convertItem.getCreateTime()))"), @Mapping(target="updateTime", expression="java(com.xforceplus.adapter.utils.DateUtils.format(convertItem.getUpdateTime()))")})
    @FreezeAmountTargetFieldMapping
    public BillItem mapToBillItem(BillConvertItem var1);

    public List<BillItem> mapToBillItems(List<BillConvertItem> var1);

    public BillItemExt mapToBillItemExt(BillConvertItem var1);

    @AfterMapping
    default public void map(BillConvertItem convertItem, @MappingTarget BillItem billItem) {
        BillItemExt itemExt = this.mapToBillItemExt(convertItem);
        billItem.setExtendJson(JsonUtils.parseMap((String)JsonUtils.serialize((Object)itemExt)));
        if (StringUtils.isNotBlank((CharSequence)convertItem.getSpecialAdditionStr())) {
            List collect;
            List maps = JsonUtils.parseList((String)convertItem.getSpecialAdditionStr(), Map.class);
            Map extendJson = billItem.getExtendJson();
            if (CollectionUtils.isEmpty((Map)extendJson)) {
                extendJson = Maps.newHashMap();
                billItem.setExtendJson(extendJson);
            }
            if (!CollectionUtils.isEmpty(collect = maps.stream().filter(m -> !CollectionUtils.isEmpty((Map)m)).collect(Collectors.toList()))) {
                extendJson.put("specialAdditions", JsonUtils.serialize(collect));
            }
        }
    }
}

