/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.mapstruct;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.receipt.vo.BillItemExt;
import com.xforceplus.seller.invoice.client.model.BillItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.springframework.util.CollectionUtils;

@Mapper(componentModel="spring")
public interface SellerBillItemMapper {
    @Mapping(ignore=true, target="specialAdditions")
    public BillItem mapToBillItem(OrdSalesbillItemVO var1);

    public List<BillItem> mapToBillItems(List<OrdSalesbillItemVO> var1);

    @Mappings(value={@Mapping(source="id", target="salesbillItemId"), @Mapping(source="itemNo", target="salesbillItemNo"), @Mapping(source="billId", target="salesbillId"), @Mapping(source="billNo", target="salesbillNo"), @Mapping(source="outerDiscountWithTax", target="outterDiscountWithTax"), @Mapping(source="outerDiscountWithoutTax", target="outterDiscountWithoutTax"), @Mapping(source="outerDiscountTax", target="outterDiscountTax")})
    public BillItem toBillItem(com.xforceplus.receipt.vo.BillItem var1);

    public List<BillItem> toBillItems(List<com.xforceplus.receipt.vo.BillItem> var1);

    @Mapping(ignore=true, target="specialAdditions")
    public void update(BillItemExt var1, @MappingTarget BillItem var2);

    @AfterMapping
    default public void map(com.xforceplus.receipt.vo.BillItem item, @MappingTarget BillItem itemVO) {
        Map extendJson = item.getExtendJson();
        if (!CollectionUtils.isEmpty((Map)extendJson)) {
            BillItemExt itemExt = (BillItemExt)JsonUtils.parse((String)JsonUtils.serialize((Object)extendJson), BillItemExt.class);
            this.update(itemExt, itemVO);
            if (Objects.nonNull(itemExt)) {
                if (CollectionUtils.isEmpty((Collection)itemExt.getSpecialAdditions())) {
                    return;
                }
                List collect = itemExt.getSpecialAdditions().stream().map(s -> {
                    HashMap map = Maps.newHashMap();
                    for (Map.Entry entry : s.entrySet()) {
                        map.put(entry.getKey(), entry.getValue());
                    }
                    return map;
                }).collect(Collectors.toList());
                itemVO.setSpecialAdditions(collect);
            }
        }
    }

    @AfterMapping
    default public void map(OrdSalesbillItemVO itemVO, @MappingTarget BillItem item) {
        List specialAdditions = itemVO.getSpecialAdditions();
        if (!CollectionUtils.isEmpty((Collection)specialAdditions)) {
            ArrayList list = Lists.newArrayList();
            for (Map specialAddition : specialAdditions) {
                HashMap map = Maps.newHashMap();
                for (Map.Entry entry : specialAddition.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                list.add(map);
            }
            item.setSpecialAdditions((List)list);
        }
    }
}

