/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.bizorder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.component.handler.TransactionalHandler;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.enums.BillItemStatus;
import com.xforceplus.adapter.mapstruct.ConverterToBillItem;
import com.xforceplus.adapter.mapstruct.ConverterToBillMain;
import com.xforceplus.phoenix.bill.client.model.OrderIssueVO;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillVehicleInfoDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillVehicleInfoEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillVehicleInfoExample;
import com.xforceplus.receipt.vo.BillAdapterRequest;
import com.xforceplus.receipt.vo.request.BillIdQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.coderbee.mybatis.batch.BatchParameter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchOperationAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private SalesBillBatchDao salesBillBatchDao;
    @Autowired
    private OrdSalesbillVehicleInfoDao salesbillVehicleInfoDao;
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private ConverterToBillItem converterToBillItem;
    @Autowired
    private ConverterToBillMain converterToBillMain;
    @Autowired
    private BillUpdateClient updateClient;
    @Autowired
    private TransactionalHandler transactionalHandler;

    public Object process(AdapterParams adapterParams) {
        List vehicleInfoEntityList;
        List salesbillEntities;
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Object salesbillList = params.get("salesbillList");
        Object vehicleInfoEntities = params.get("vehicleInfoEntities");
        Object salesbillItemList = params.get("salesbillItemList");
        Object itemMap = params.get("itemMap");
        Object issuItemIds = params.get("issuItemIds");
        ArrayList insertMains = Lists.newArrayList();
        ArrayList updateMains = Lists.newArrayList();
        ArrayList<OrdSalesbillItemEntity> insertItemsList = new ArrayList<OrdSalesbillItemEntity>();
        ArrayList<OrdSalesbillItemEntity> updateItemsList = new ArrayList<OrdSalesbillItemEntity>();
        List items = Lists.newArrayList();
        ArrayList insertVehicleBillList = new ArrayList();
        ArrayList updateVehicleBillList = new ArrayList();
        Map map = Maps.newHashMap();
        if (Objects.nonNull(salesbillList) && !CollectionUtils.isEmpty((Collection)(salesbillEntities = (List)salesbillList))) {
            List billIds = salesbillEntities.stream().map(s -> s.getSalesbillId()).collect(Collectors.toList());
            BillIdQueryRequest request = new BillIdQueryRequest();
            request.setMainIds(billIds);
            request.setSellerGroupId(Long.valueOf(tenantId));
            request.setStatus(BillItemStatus.NORMAL.value());
            Response response = this.mainClient.queryBillsByIds(tenantId, request);
            if (!CollectionUtils.isEmpty((Collection)((Collection)response.getResult()))) {
                List collect = ((List)response.getResult()).stream().map(r -> r.getId()).collect(Collectors.toList());
                List<OrdSalesbillEntity> entities = salesbillEntities.stream().filter(main -> collect.contains(main.getSalesbillId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(entities)) {
                    updateMains.addAll(this.createUpdateMain(entities));
                    List ids = entities.stream().map(e -> e.getSalesbillId()).collect(Collectors.toList());
                    salesbillEntities = salesbillEntities.stream().filter(s -> !ids.contains(s.getSalesbillId())).collect(Collectors.toList());
                }
            }
            insertMains.addAll(salesbillEntities);
        }
        if (Objects.nonNull(vehicleInfoEntities) && !CollectionUtils.isEmpty((Collection)(vehicleInfoEntityList = (List)vehicleInfoEntities))) {
            List salesbillIds = vehicleInfoEntityList.stream().map(OrdSalesbillVehicleInfoEntity::getSalesbillId).collect(Collectors.toList());
            OrdSalesbillVehicleInfoExample vehicleInfoExample = new OrdSalesbillVehicleInfoExample();
            vehicleInfoExample.createCriteria().andSalesbillIdIn(salesbillIds);
            List vehicleList = this.salesbillVehicleInfoDao.selectByExample(vehicleInfoExample);
            Map<Long, OrdSalesbillVehicleInfoEntity> vehicleInfoEntityMap = vehicleList.stream().collect(Collectors.toMap(OrdSalesbillVehicleInfoEntity::getSalesbillId, v -> v));
            vehicleInfoEntityList.forEach(v -> {
                OrdSalesbillVehicleInfoEntity entity = (OrdSalesbillVehicleInfoEntity)vehicleInfoEntityMap.get(v.getSalesbillId());
                if (entity != null) {
                    updateVehicleBillList.add(v);
                } else {
                    insertVehicleBillList.add(v);
                }
            });
        }
        if (Objects.nonNull(itemMap)) {
            map = (Map)itemMap;
        }
        HashSet<Long> makeIds = new HashSet<Long>();
        if (Objects.nonNull(salesbillItemList)) {
            items = (List)salesbillItemList;
            Map<Long, OrdSalesbillEntity> insertBillMap = insertMains.stream().collect(Collectors.toMap(OrdSalesbillEntity::getSalesbillId, v -> v));
            for (OrdSalesbillItemEntity itemEntity : items) {
                OrdSalesbillItemEntity oldItemEntity = (OrdSalesbillItemEntity)map.get(itemEntity.getSalesbillItemId());
                if (oldItemEntity != null) {
                    if (oldItemEntity.getStatus() == BillItemStatus.NORMAL.value()) {
                        updateItemsList.add(itemEntity);
                    }
                    map.remove(itemEntity.getSalesbillItemId());
                    continue;
                }
                itemEntity.setAlreadyAmountWithoutTax(BigDecimal.ZERO);
                itemEntity.setAlreadyAmountWithTax(BigDecimal.ZERO);
                itemEntity.setAlreadyTaxAmount(BigDecimal.ZERO);
                insertItemsList.add(itemEntity);
                OrdSalesbillEntity billEntity = insertBillMap.get(itemEntity.getSalesbillId());
                if (billEntity == null || !billEntity.getSystemOrigType().equals(2)) continue;
                makeIds.add(billEntity.getSalesbillId());
            }
        }
        BillAdapterRequest adapterRequest = new BillAdapterRequest();
        adapterRequest.setInsertMains(this.converterToBillMain.mapToBillMains(insertMains));
        adapterRequest.setUpdateMains(this.converterToBillMain.mapToBillMains(updateMains));
        adapterRequest.setInsertItems(this.converterToBillItem.mapToBillItems(insertItemsList));
        adapterRequest.setUpdateItems(this.converterToBillItem.mapToBillItems(updateItemsList));
        if (!map.isEmpty()) {
            adapterRequest.setDeleteItems(new ArrayList(map.keySet()));
        }
        this.transactionalHandler.execute(Arrays.asList(() -> {
            Response response = this.updateClient.adapterUpdate(tenantId, adapterRequest);
            return !(!response.isOk() || !CollectionUtils.isEmpty((Collection)insertVehicleBillList) && this.salesBillBatchDao.vehicleBatchInsert(BatchParameter.wrap((List)insertVehicleBillList)) <= 0 || !CollectionUtils.isEmpty((Collection)updateVehicleBillList) && this.salesBillBatchDao.updateVehicleBatchSelective(updateVehicleBillList) <= 0);
        }));
        if (Objects.nonNull(issuItemIds)) {
            OrderIssueVO issueVO;
            ArrayList<OrderIssueVO> orderIssueVOList = new ArrayList<OrderIssueVO>();
            List ids = (List)issuItemIds;
            Map issueMap = items.stream().filter(v -> ids.contains(v.getSalesbillItemId())).collect(Collectors.groupingBy(OrdSalesbillItemEntity::getSalesbillId, Collectors.mapping(OrdSalesbillItemEntity::getSalesbillItemId, Collectors.toList())));
            for (Map.Entry entry : issueMap.entrySet()) {
                issueVO = new OrderIssueVO();
                issueVO.setId(entry.getKey());
                issueVO.setItemIds(entry.getValue());
                orderIssueVOList.add(issueVO);
            }
            for (Long salesbillId : makeIds) {
                issueVO = new OrderIssueVO();
                issueVO.setId(salesbillId);
                issueVO.setItemIds((List)Lists.newArrayList());
                orderIssueVOList.add(issueVO);
            }
            return orderIssueVOList;
        }
        return Lists.newArrayList();
    }

    private List<OrdSalesbillEntity> createUpdateMain(List<OrdSalesbillEntity> entities) {
        return entities.stream().map(v -> {
            OrdSalesbillEntity billEntity = new OrdSalesbillEntity();
            if (StringUtils.isNotEmpty((CharSequence)v.getImportBatchNo())) {
                billEntity.setImportBatchNo(v.getImportBatchNo());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getInvoiceType())) {
                billEntity.setInvoiceType(v.getInvoiceType());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getPurchaserTaxNo())) {
                billEntity.setPurchaserTaxNo(v.getPurchaserTaxNo());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getPurchaserBankName())) {
                billEntity.setPurchaserBankName(v.getPurchaserBankName());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getPurchaserName())) {
                billEntity.setPurchaserName(v.getPurchaserName());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getPurchaserTel())) {
                billEntity.setPurchaserTel(v.getPurchaserTel());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getPurchaserBankAccount())) {
                billEntity.setPurchaserBankAccount(v.getPurchaserBankAccount());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getPurchaserAddress())) {
                billEntity.setPurchaserAddress(v.getPurchaserAddress());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getReceiveUserTel())) {
                billEntity.setReceiveUserTel(v.getReceiveUserTel());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getReceiveUserEmail())) {
                billEntity.setReceiveUserEmail(v.getReceiveUserEmail());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getCheckerName())) {
                billEntity.setCheckerName(v.getCheckerName());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getInvoicerName())) {
                billEntity.setInvoicerName(v.getInvoicerName());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getCashierName())) {
                billEntity.setCashierName(v.getCashierName());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getRemark())) {
                billEntity.setRemark(v.getRemark());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getSystemOrig())) {
                billEntity.setSystemOrig(v.getSystemOrig());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getSellerBankName())) {
                billEntity.setSellerBankName(v.getSellerBankName());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getSellerTel())) {
                billEntity.setSellerTel(v.getSellerTel());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getSellerBankAccount())) {
                billEntity.setSellerBankAccount(v.getSellerBankAccount());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getSellerAddress())) {
                billEntity.setSellerAddress(v.getSellerAddress());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getExt25())) {
                billEntity.setExt25(v.getExt25());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getExt24())) {
                billEntity.setExt24(v.getExt24());
            }
            if (Objects.nonNull(v.getSystemOrigType())) {
                billEntity.setSystemOrigType(v.getSystemOrigType());
            }
            billEntity.setSalesbillId(v.getSalesbillId());
            return billEntity;
        }).collect(Collectors.toList());
    }

    public String adapterName() {
        return "batchOperation";
    }
}

