/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SellerBillInfoMapper;
import com.xforceplus.adapter.mapstruct.SellerBillItemMapper;
import com.xforceplus.invoice.transfer.TransferHelper;
import com.xforceplus.invoice.transfer.enums.TaxPreConEnum;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.model.SplitGroup;
import com.xforceplus.phoenix.bill.client.enums.BillMergeType;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.MakeoutInvoiceRequest;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.api.BillUpdateApi;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.enums.InvoiceType;
import com.xforceplus.seller.enums.SplitType;
import com.xforceplus.seller.invoice.client.model.BillInfo;
import com.xforceplus.seller.invoice.client.model.BillItem;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceResponse;
import com.xforceplus.xplatframework.apimodel.AsyncModel;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.util.CommonTools;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProcessMakeOutInvoiceAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(ProcessMakeOutInvoiceAdapter.class);
    @Value(value="${bill.new.make.out}")
    private int billNewMakeOut;
    @Autowired
    private BillAdapterService billAdapterService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private SellerBillItemMapper sellerBillItemMapper;
    @Autowired
    private SellerBillInfoMapper sellerBillInfoMapper;
    @Autowired
    private BillUpdateApi billUpdateApi;
    private static final List<String> immediateTypeList = Lists.newArrayList((Object[])new String[]{"\u8f6f\u4ef6\u4ea7\u54c1", "\u8d44\u6e90\u7efc\u5408\u5229\u7528\u4ea7\u54c1", "\u7ba1\u9053\u8fd0\u8f93\u670d\u52a1", "\u6709\u5f62\u52a8\u4ea7\u878d\u8d44\u79df\u8d41\u670d\u52a1", "\u6709\u5f62\u52a8\u4ea7\u878d\u8d44\u6027\u552e\u540e\u56de\u79df\u670d\u52a1", "\u65b0\u578b\u5899\u4f53\u6750\u6599", "\u98ce\u529b\u53d1\u7535\u4ea7\u54c1", "\u5149\u4f0f\u53d1\u7535\u4ea7\u54c1", "\u5149\u4f0f\u53d1\u7535\u4ea7\u54c1", "\u52a8\u6f2b\u8f6f\u4ef6\u4ea7\u54c1", "\u98de\u673a\u7ef4\u4fee\u52b3\u52a1", "\u9ec4\u91d1", "\u94c2\u91d1"});
    private static final String immediateDisplayName = "\u5373\u5f81\u5373\u9000";
    public static List<String> itemTypeCodeExcludeCpyOrJdcList = Lists.newArrayList((Object[])new String[]{"01", "02", "03", "04", "05", "06", "12"});

    public Object process(AdapterParams adapterParams) {
        SplitPreInvoiceResponse splitPreInvoiceResponse;
        Map paramMap = adapterParams.getParams();
        List outSplitGroupList = (List)paramMap.get("outSplitGroupList");
        MakeoutInvoiceRequest makeoutInvoiceRequest = (MakeoutInvoiceRequest)paramMap.get("makeoutInvoiceRequest");
        Long tmpRuleId = (Long)paramMap.get("tmpRuleId");
        SearchSort sort = (SearchSort)paramMap.get("sort");
        String terminalCode = (String)paramMap.get("terminalCode");
        String terminalName = (String)paramMap.get("terminalName");
        Integer splitType = (Integer)paramMap.get("splitType");
        List autoMakesalesBillIds = (List)paramMap.get("autoMakesalesBillIds");
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        BaseAsyncResponse baseAsyncResponse = new BaseAsyncResponse();
        try {
            if (CollectionUtils.isEmpty((Collection)outSplitGroupList)) {
                throw new IllegalArgumentException("\u65e0\u6570\u636e\u62c6\u7968.");
            }
            String operatorUser = "\u7cfb\u7edf";
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            log.info("splitAndMakeOutUser:{}", (Object)JsonUtils.writeObjectToFastJson((Object)userInfo));
            if (userInfo != null) {
                operatorUser = userInfo.getUserName();
            }
            HashSet<Long> set = new HashSet<Long>();
            ArrayList<SplitPreInvoiceRequest> splitPreInvoiceRequestList = new ArrayList<SplitPreInvoiceRequest>();
            HashMap<Long, List> noneMergeItems = new HashMap<Long, List>();
            HashMap<Long, List> mergeItems = new HashMap<Long, List>();
            HashMap noneMergeBill = new HashMap();
            HashMap mergeBill = new HashMap();
            for (SplitGroup splitGroup : outSplitGroupList) {
                List<OrdSalesbillItemVO> itemVOS = splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillItemVO).collect(Collectors.toList());
                splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillVO).forEach(x -> noneMergeBill.put(x.getSalesbillId(), this.sellerBillInfoMapper.mapToBillInfo((OrdSalesbillVO)x)));
                if (Objects.equals(splitGroup.getMergeType(), BillMergeType.NONE.value())) {
                    splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillVO).forEach(x -> noneMergeBill.put(x.getSalesbillId(), this.sellerBillInfoMapper.mapToBillInfo((OrdSalesbillVO)x)));
                    noneMergeItems.computeIfAbsent(splitGroup.getBatchNo(), k -> new ArrayList()).addAll(this.sellerBillItemMapper.mapToBillItems(itemVOS));
                    continue;
                }
                splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillVO).forEach(x -> mergeBill.put(x.getSalesbillId(), this.sellerBillInfoMapper.mapToBillInfo((OrdSalesbillVO)x)));
                mergeItems.computeIfAbsent(splitGroup.getBatchNo(), k -> new ArrayList()).addAll(this.sellerBillItemMapper.mapToBillItems(itemVOS));
            }
            for (SplitGroup makeOutVo : outSplitGroupList) {
                long batchNo = makeOutVo.getBatchNo();
                long ruleId = makeOutVo.getRuleId();
                int mergeType = makeOutVo.getMergeType();
                if (set.contains(batchNo)) {
                    throw new IllegalArgumentException("\u6279\u6b21\u53f7" + batchNo + "\u4e0d\u80fd\u5206\u6279\u7ec4\u88c5.");
                }
                set.add(batchNo);
                SplitPreInvoiceRequest splitPreInvoiceRequest = new SplitPreInvoiceRequest();
                splitPreInvoiceRequest.setAutoMakesalesBillIds(Collections.emptyList());
                splitPreInvoiceRequest.setMergeType(mergeType);
                splitPreInvoiceRequest.setSplitType(ProcessMakeOutInvoiceAdapter.splitTypeCheck(splitType).intValue());
                splitPreInvoiceRequest.setBatchNo(Long.valueOf(batchNo));
                splitPreInvoiceRequest.setTerminalCode(terminalCode);
                splitPreInvoiceRequest.setTerminalName(terminalName);
                splitPreInvoiceRequest.setOperatorUser(operatorUser);
                splitPreInvoiceRequest.setBillInfo(this.billAdapterService.buildBillInfo(mergeType, batchNo, noneMergeItems, mergeItems, noneMergeBill, mergeBill, null, null));
                splitPreInvoiceRequest.setSplitRule(this.billAdapterService.buildSplitRule(ruleId, splitPreInvoiceRequest.getBillInfo()));
                splitPreInvoiceRequest.setAutoMakesalesBillIds(autoMakesalesBillIds);
                OrdSalesbillVO ordSalesbillVO = ((OrdSalesbillDetailVO)makeOutVo.getList().get(0)).getOrdSalesbillVO();
                splitPreInvoiceRequest.setMakingReason(ordSalesbillVO.getMakingReason());
                splitPreInvoiceRequestList.add(splitPreInvoiceRequest);
                List billItems = splitPreInvoiceRequest.getBillInfo().getBillItems();
                this.convertImmediate(splitPreInvoiceRequest.getSplitRule().getTaxInvoiceSource(), billItems, splitPreInvoiceRequest.getBillInfo());
            }
            List taxInvoiceSources = splitPreInvoiceRequestList.stream().map(s -> s.getSplitRule().getTaxInvoiceSource()).filter(s -> StringUtils.isNotEmpty((CharSequence)s)).distinct().collect(Collectors.toList());
            if (taxInvoiceSources.size() > 1) {
                throw new IllegalArgumentException("\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u4e0d\u4e00\u81f4\uff0c\u8bf7\u7b5b\u9009\u300c\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u300d\u6216\u68c0\u67e5\u300c\u62c6\u7968\u89c4\u5219\u300d\u540e\u91cd\u8bd5");
            }
            List batchNoList = splitPreInvoiceRequestList.stream().map(SplitPreInvoiceRequest::getBatchNo).collect(Collectors.toList());
            String json = JsonUtils.writeObjectToFastJson(batchNoList);
            if (json.length() > 2000) {
                String random = UUID.randomUUID().toString();
                String filePath = this.billAdapterService.getSalesSplitRequestDataPath() + random;
                try {
                    log.info("\u4e0a\u4f20\u62c6\u7968\u8bf7\u6c42\u5230oss/minio path:{}", (Object)filePath);
                    String key = this.billAdapterService.putFileToOss(json, filePath);
                    log.info("splitPreInvoiceRequestList params batchNo:{},\u751f\u6210\u7684key:{}", (Object)random, (Object)key);
                }
                catch (Exception e) {
                    log.error("\u4e0a\u4f20\u62c6\u7968\u8bf7\u6c42\u5230oss/minio\u5f02\u5e38", (Throwable)e);
                }
            } else {
                log.info("splitPreInvoiceRequestList params batchNo:{}", (Object)json);
            }
            splitPreInvoiceResponse = this.billAdapterService.splitAndMakeOut(splitPreInvoiceRequestList);
        }
        catch (Exception e) {
            log.error("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            StringBuilder msgTips = new StringBuilder();
            msgTips.append(e.getMessage());
            List collect = outSplitGroupList.stream().map(SplitGroup::getBatchNo).collect(Collectors.toList());
            log.info("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!batchNo:{} \u6267\u884c\u56de\u6eda! ", collect);
            Response response = this.billUpdateApi.afterPreInvDeleteBillStatus(adapterParams.getTenantId(), collect);
            if (response.isOk()) {
                msgTips.append(String.format("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!batchNo:%s \u5df2\u7ecf\u56de\u6eda! ", collect));
            } else {
                log.info("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!\u56de\u6eda\u6279\u6b21\u53f7\u5931\u8d25,\u9700\u8981\u4eba\u5de5\u5904\u7406,response:{},batchNo:{}", (Object)response.getMessage(), collect);
                msgTips.append(String.format("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!\u56de\u6eda\u6279\u6b21\u53f7\u5931\u8d25,\u9700\u8981\u4eba\u5de5\u5904\u7406.batchNo:%s ", collect));
            }
            makeOutInvoiceResponse.setCode(com.xforceplus.xplatframework.model.Response.Fail);
            makeOutInvoiceResponse.setMessage(msgTips.toString());
            return makeOutInvoiceResponse;
        }
        makeOutInvoiceResponse.setCode(com.xforceplus.xplatframework.model.Response.OK);
        makeOutInvoiceResponse.setMessage("\u5f00\u7968\u6d88\u606f\u5df2\u53d1\u51fa.");
        if (this.billNewMakeOut == 1) {
            AsyncModel asyncModel = this.billAdapterService.createAsyncModel(splitPreInvoiceResponse.getTaskId().longValue());
            makeOutInvoiceResponse.setResult(asyncModel);
        } else {
            makeOutInvoiceResponse.setResult(baseAsyncResponse.getResult());
        }
        log.info("makeOutResponse:" + makeOutInvoiceResponse);
        return makeOutInvoiceResponse;
    }

    public void convertImmediate(String taxInvoiceSource, List<BillItem> billItems, BillInfo billInfo) throws IllegalArgumentException {
        billItems.forEach(billItem -> {
            String goodsTaxNo = billItem.getGoodsTaxNo();
            if (StringUtils.isEmpty((CharSequence)goodsTaxNo)) {
                throw new IllegalArgumentException("\u4e1a\u52a1\u5355\u53f7:\u3010 " + billItem.getSalesbillNo() + "\u3011\u660e\u7ec6\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801,\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5168\u4e4b\u540e\u518d\u6267\u884c\u5f00\u7968\u64cd\u4f5c.");
            }
            if ("qd".equals(taxInvoiceSource)) {
                if (StringUtils.isNotEmpty((CharSequence)billItem.getTaxPreCon()) && billItem.getTaxPreCon().contains(immediateDisplayName)) {
                    boolean anyMatch = immediateTypeList.stream().anyMatch(it -> billItem.getTaxPreCon().contains((CharSequence)it));
                    if (!anyMatch) {
                        throw new IllegalArgumentException("\u60a8\u5f53\u524d\u9009\u62e9\u7684\u5355\u636e\u7f3a\u5c11\u4f18\u60e0\u653f\u7b56-\u5373\u5f81\u5373\u9000\u7c7b\u578b\uff08\u5168\u7535\uff09\u5185\u5bb9\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5f00\u7968");
                    }
                } else {
                    Optional optional = TransferHelper.transferEInvoicePreInfo((String)billItem.getTaxPreCon(), (BigDecimal)new BigDecimal(billItem.getTaxRate()));
                    if (!optional.isPresent()) {
                        throw new IllegalArgumentException("\u60a8\u5f53\u524d\u9009\u62e9\u7684\u5355\u636e\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5f00\u7968");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)billItem.getItemTypeCode()) && "KCP".equals(billItem.getItemTypeCode())) {
                    billItem.setItemTypeCode("");
                }
            } else {
                Optional optional = TransferHelper.transferEInvoicePreInfo((String)billItem.getTaxPreCon(), (BigDecimal)new BigDecimal(billItem.getTaxRate()));
                optional.ifPresent(op -> {
                    TaxPreConEnum preConEnum = (TaxPreConEnum)op.getValue0();
                    if (preConEnum != null) {
                        billItem.setTaxPreCon(preConEnum.getTaxPreCon());
                        billItem.setTaxPre(preConEnum.getTaxPre());
                        billItem.setZeroTax(preConEnum.getZeroTaxCode());
                    }
                });
                if (StringUtils.isNotEmpty((CharSequence)billItem.getItemTypeCode()) && itemTypeCodeExcludeCpyOrJdcList.contains(billItem.getItemTypeCode())) {
                    billItem.setItemTypeCode("");
                }
                if ((CommonTools.isEmpty((String)billInfo.getSellerBankName()) || CommonTools.isEmpty((String)billInfo.getSellerBankAccount()) || CommonTools.isEmpty((String)billInfo.getSellerAddress()) || CommonTools.isEmpty((String)billInfo.getPurchaserBankName()) || CommonTools.isEmpty((String)billInfo.getPurchaserBankAccount()) || CommonTools.isEmpty((String)billInfo.getPurchaserAddress())) && StringUtils.equalsAny((CharSequence)billInfo.getInvoiceType(), (CharSequence[])new CharSequence[]{InvoiceType.SPECIAL.value(), InvoiceType.SPECIAL_ELECTRONIC.value()})) {
                    throw new IllegalArgumentException("\u5f00\u7968\u65b9\u5f0f\u4e3a\u7a0e\u63a7\u3001\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u3001\u8d2d\u9500\u65b9 \u5730\u5740\u3001\u7535\u8bdd\u3001\u94f6\u884c\u3001\u8d26\u53f7\u9700\u8981\u5168\u90e8\u586b\u5199");
                }
                if (CommonTools.isEmpty((String)billInfo.getSellerBankName()) || CommonTools.isEmpty((String)billInfo.getSellerBankAccount()) || CommonTools.isEmpty((String)billInfo.getSellerAddress())) {
                    throw new IllegalArgumentException("\u5f00\u7968\u65b9\u5f0f\u4e3a\u7a0e\u63a7,\u9500\u65b9 \u5730\u5740\u3001\u7535\u8bdd\u3001\u94f6\u884c\u3001\u8d26\u53f7\u9700\u8981\u5168\u90e8\u586b\u5199");
                }
            }
        });
    }

    public static Integer splitTypeCheck(Integer type) {
        if (Objects.isNull(type) || SplitType.MANUAL.value() == type.intValue()) {
            return 0;
        }
        return type;
    }

    public String adapterName() {
        return "processMakeOutInvoice";
    }
}

