/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillDetailClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.InvoiceBillItemMapper;
import com.xforceplus.adapter.mapstruct.InvoiceBillMainMapper;
import com.xforceplus.phoenix.bill.client.model.BillBatchQueryResponse;
import com.xforceplus.phoenix.bill.client.model.BillInvoiceBatchQueryRequest;
import com.xforceplus.phoenix.bill.client.model.BillInvoiceQueryParams;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillItem;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillMain;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillDetailByListBatchNoAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillDetailByListBatchNoAdapter.class);
    @Autowired
    private BillDetailClient billDetailClient;
    @Autowired
    private InvoiceBillMainMapper invoiceBillMainMapper;
    @Autowired
    private InvoiceBillItemMapper invoiceBillItemMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map paramMap = adapterParams.getParams();
        BillInvoiceBatchQueryRequest queryRequest = (BillInvoiceBatchQueryRequest)paramMap.get("request");
        List queryParamsList = queryRequest.getQueryParamsList();
        SearchSort sort = queryRequest.getSort();
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        ArrayList list = Lists.newArrayList();
        for (BillInvoiceQueryParams billInvoiceQueryParams : queryParamsList) {
            Long batchNo = billInvoiceQueryParams.getBatchNo();
            int mergeType = billInvoiceQueryParams.getMergeType();
            list.add(batchNo);
            Response response = this.billDetailClient.queryBillByMergeType(tenantId, Integer.valueOf(mergeType), batchNo, sort);
            List result = (List)response.getResult();
            if (CollectionUtils.isEmpty((Collection)result)) continue;
            List invoiceMainList = result.stream().map(detail -> {
                BillMain main = detail.getMain();
                List items = detail.getItems();
                InvoiceBillMain invoiceBillMain = this.invoiceBillMainMapper.mapToInvoiceBillMain(main);
                List<InvoiceBillItem> invoiceBillItems = this.invoiceBillItemMapper.mapToInvoiceBillItems(items);
                invoiceBillMain.setBillItems(invoiceBillItems);
                return invoiceBillMain;
            }).collect(Collectors.toList());
            resultMap.put(batchNo, invoiceMainList);
        }
        if (CollectionUtils.isEmpty((Map)resultMap)) {
            return BillBatchQueryResponse.fail((List)list, (String)"\u6839\u636e\u6279\u6b21\u53f7\u672a\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f");
        }
        return BillBatchQueryResponse.ok(new ArrayList(resultMap.keySet()), (String)"", (Map)resultMap);
    }

    public String adapterName() {
        return "mainBatchListByBatchNo";
    }
}

