/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.enums.PriceMethodTypeEnum;
import com.xforceplus.adapter.mapstruct.InvoiceBillMainExtMapper;
import com.xforceplus.phoenix.bill.client.model.BillInfoQueryResponse;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillMainExt;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.response.Response;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillMainListExtByIdQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillMainListExtByIdQueryAdapter.class);
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private BillItemClient itemClient;
    @Autowired
    private InvoiceBillMainExtMapper invoiceBillMainExtMapper;
    @Value(value="#{'${receipt.skip.item-query.tenantId:0}'.split(',')}")
    private List<Long> tenantIds;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map paramMap;
        List billIds;
        String tenantId = adapterParams.getTenantId();
        Response response = this.billMainClient.queryAutoBillOrBills(tenantId, billIds = (List)(paramMap = adapterParams.getParams()).get("billIdList"));
        List<InvoiceBillMainExt> billExtList = this.invoiceBillMainExtMapper.mapToInvoiceBillMainExt((List)response.getResult());
        if (!CollectionUtils.isEmpty(billExtList) && !this.tenantIds.contains(Long.valueOf(tenantId))) {
            log.info("billMainListExtByIdQueryAdapter-queryItem!");
            Response itemResponse = this.itemClient.queryBillItemByBillId(tenantId, billIds);
            List billItems = (List)itemResponse.getResult();
            if (!CollectionUtils.isEmpty((Collection)billItems)) {
                Map<Long, List<BillItem>> group = billItems.stream().collect(Collectors.groupingBy(k -> k.getBillId()));
                for (InvoiceBillMainExt invoiceBillMainExt : billExtList) {
                    List<BillItem> items = group.get(invoiceBillMainExt.getSalesbillId());
                    if (CollectionUtils.isEmpty(items)) continue;
                    invoiceBillMainExt.setMatched(false);
                    BigDecimal positiveWithTaxAmount = BigDecimal.ZERO;
                    BigDecimal negativeWithTaxAmount = BigDecimal.ZERO;
                    BigDecimal positiveWithoutTaxAmount = BigDecimal.ZERO;
                    BigDecimal negativeWithoutTaxAmount = BigDecimal.ZERO;
                    for (BillItem item : items) {
                        if (BigDecimal.ZERO.compareTo(item.getAmountWithTax()) < 0) {
                            positiveWithTaxAmount = positiveWithTaxAmount.add(this.queryDetailAllowIssueAmount(item, PriceMethodTypeEnum.WITH_PRICE));
                        } else {
                            negativeWithTaxAmount = negativeWithTaxAmount.add(this.queryDetailAllowIssueAmount(item, PriceMethodTypeEnum.WITH_PRICE));
                        }
                        if (BigDecimal.ZERO.compareTo(item.getAmountWithoutTax()) < 0) {
                            positiveWithoutTaxAmount = positiveWithoutTaxAmount.add(this.queryDetailAllowIssueAmount(item, PriceMethodTypeEnum.WITHOUT_PRICE));
                            continue;
                        }
                        negativeWithoutTaxAmount = negativeWithoutTaxAmount.add(this.queryDetailAllowIssueAmount(item, PriceMethodTypeEnum.WITHOUT_PRICE));
                    }
                    invoiceBillMainExt.setPositiveDetailsAllowIssueWithTaxAmount(positiveWithTaxAmount);
                    invoiceBillMainExt.setNegativeDetailsAllowIssueWithTaxAmount(negativeWithTaxAmount);
                    invoiceBillMainExt.setPositiveDetailsAllowIssueWithoutTaxAmount(positiveWithoutTaxAmount);
                    invoiceBillMainExt.setNegativeDetailsAllowIssueWithoutTaxAmount(negativeWithoutTaxAmount);
                }
            }
        }
        BillInfoQueryResponse billInfoQueryResponse = new BillInfoQueryResponse();
        billInfoQueryResponse.setResult(billExtList);
        billInfoQueryResponse.setCode(com.xforceplus.xplatframework.model.Response.OK);
        billInfoQueryResponse.setMessage("\u67e5\u8be2\u6210\u529f.");
        return billInfoQueryResponse;
    }

    public String adapterName() {
        return "queryBillExtByIds";
    }

    public BigDecimal queryDetailAllowIssueAmount(BillItem item, PriceMethodTypeEnum priceMethod) {
        if (PriceMethodTypeEnum.WITH_PRICE == priceMethod) {
            return this.subtract(item.getAmountWithTax(), this.add(item.getInnerDiscountWithTax(), item.getOuterDiscountWithTax(), item.getInnerPrepayAmountWithTax(), item.getOuterPrepayAmountWithTax(), item.getFreezeAmountWithTax(), item.getAlreadyAmountWithTax()));
        }
        return this.subtract(item.getAmountWithoutTax(), this.add(item.getInnerDiscountWithoutTax(), item.getOuterDiscountWithoutTax(), item.getInnerPrepayAmountWithoutTax(), item.getOuterPrepayAmountWithoutTax(), item.getFreezeAmountWithoutTax(), item.getAlreadyAmountWithoutTax()));
    }

    public BigDecimal add(BigDecimal ... addItem) {
        return Arrays.stream(addItem).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public BigDecimal subtract(BigDecimal bd1, BigDecimal bd2) {
        return bd1.subtract(bd2);
    }
}

