/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.ConverterToMainEntity;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.vo.ReceiptSearchSort;
import com.xforceplus.receipt.vo.request.BillIdQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillSelectBillByIdAndSortAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private ConverterToMainEntity converterToMainEntity;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        List mainIds = (List)params.get("billIds");
        BillIdQueryRequest billIdQueryRequest = new BillIdQueryRequest();
        billIdQueryRequest.setMainIds(mainIds);
        if (Objects.nonNull(params.get("searchSort"))) {
            SearchSort searchSort = (SearchSort)params.get("searchSort");
            ReceiptSearchSort receiptSearchSort = BillGetBillListOptimizeAdapter.initSearchSorts(searchSort);
            List searchSorts = CollectionUtils.isEmpty((Collection)receiptSearchSort.getSearchSort()) ? Lists.newArrayList((Object[])new ReceiptSearchSort[]{receiptSearchSort}) : receiptSearchSort.getSearchSort();
            billIdQueryRequest.setSearchSorts(searchSorts);
        }
        Response response = this.mainClient.queryBillsByIds(adapterParams.getTenantId(), billIdQueryRequest);
        return this.converterToMainEntity.converterToList((List)response.getResult());
    }

    public String adapterName() {
        return "selectBillByIdAndSort";
    }
}

