/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SellerBillInfoMapper;
import com.xforceplus.receipt.vo.request.BillIdQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetBillAutoReturnMapAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private SellerBillInfoMapper billInfoMapper;

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        if (Objects.isNull(params.get("salesbillIds"))) {
            return Maps.newHashMap();
        }
        List salesbillIds = (List)params.get("salesbillIds");
        if (CollectionUtils.isEmpty((Collection)salesbillIds)) {
            return Maps.newHashMap();
        }
        BillIdQueryRequest billIdQueryRequest = new BillIdQueryRequest();
        billIdQueryRequest.setMainIds(salesbillIds);
        Response response = this.mainClient.queryBillsByIds(tenantId, billIdQueryRequest);
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Maps.newHashMap();
        }
        return this.billInfoMapper.toBillInfos(result).stream().collect(Collectors.toMap(k -> Long.valueOf(k.getSalesbillId()), v -> v));
    }

    public String adapterName() {
        return "getBillAutoReturnMap";
    }
}

