/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.ConverterToBillMain;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.receipt.vo.BillAdapterRequest;
import com.xforceplus.receipt.vo.BillMain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BatchUpdateBillsAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BatchUpdateBillsAdapter.class);
    @Autowired
    private ConverterToBillMain converterToBillMain;
    @Autowired
    private BillUpdateClient updateClient;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        OrdSalesbillEntity updateEntity = (OrdSalesbillEntity)params.get("updateEntity");
        List billIdList = (List)params.get("billIdList");
        if (CollectionUtils.isEmpty((Collection)billIdList)) {
            return null;
        }
        List billMainList = billIdList.stream().map(id -> {
            BillMain billMain = this.converterToBillMain.mapToBillMain(updateEntity);
            billMain.setId(id);
            return billMain;
        }).collect(Collectors.toList());
        BillAdapterRequest billAdapterRequest = new BillAdapterRequest();
        billAdapterRequest.setUpdateMains(billMainList);
        this.updateClient.adapterUpdate(tenantId, billAdapterRequest);
        return null;
    }

    public String adapterName() {
        return "batchUpdateBills";
    }
}

