/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.component.BillMatchInvoiceComponent;
import com.xforceplus.adapter.core.client.BillBackFillClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.NoticeBillReleaseMsgMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.phoenix.bill.client.api.adapter.model.BillMatchInvoiceVo;
import com.xforceplus.receipt.enums.InvoiceOperationEnum;
import com.xforceplus.receipt.enums.ReleaseDetailEnum;
import com.xforceplus.receipt.vo.request.InvBackFillRequest;
import com.xforceplus.receipt.vo.request.InvMakeOutBackFillRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.invoice.client.model.InvoiceOperation;
import com.xforceplus.seller.invoice.client.model.NoticeBillReleaseMsg;
import com.xforceplus.seller.invoice.client.model.PreInvoiceReleaseType;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RevertBillAndItemAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(RevertBillAndItemAdapter.class);
    @Autowired
    private BillBackFillClient backFillClient;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private NoticeBillReleaseMsgMapper billReleaseMsgMapper;
    @Autowired
    private BillMatchInvoiceComponent matchInvoiceComponent;
    @Autowired
    private RabbitmqService rabbitmqService;
    @Value(value="${receipt.adapter.issued.open:false}")
    private Boolean adapterIssuedOpen;

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        NoticeBillReleaseMsg releaseMsg = (NoticeBillReleaseMsg)JsonUtils.parse((String)JsonUtils.serialize(params.get("releaseMsg")), NoticeBillReleaseMsg.class);
        Map headers = JsonUtils.parseMap((String)JsonUtils.serialize(params.get("headers")));
        UserInfo info = (UserInfo)this.userInfoHolder.get();
        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        InvMakeOutBackFillRequest invMakeOutBackFillRequest = this.billReleaseMsgMapper.mapToRequest(releaseMsg);
        InvBackFillRequest request = new InvBackFillRequest();
        PreInvoiceReleaseType preInvoiceReleaseType = releaseMsg.getPreInvoiceReleaseType();
        switch (preInvoiceReleaseType) {
            case RELEASE: {
                request.setReleaseDetailEnum(ReleaseDetailEnum.RELEASE_PRE_INV);
                break;
            }
            case NOT_RELEASE: {
                request.setReleaseDetailEnum(ReleaseDetailEnum.NOT_RELEASE);
                break;
            }
            case RELEASE_BILL: {
                request.setReleaseDetailEnum(ReleaseDetailEnum.RELEASE_BILL);
                break;
            }
        }
        request.setOperationType(InvoiceOperationEnum.of((int)releaseMsg.getOperationType().value()));
        request.setUserInfo(userInfo);
        request.setBackFillRequests(Arrays.asList(invMakeOutBackFillRequest));
        Response response = this.backFillClient.invBackFillBill(tenantId, request);
        List<Object> billIds = Lists.newArrayList();
        if (InvoiceOperation.HC_INVOICE.equals((Object)releaseMsg.getOperationType())) {
            Integer invoiceOrigin;
            ArrayList billMatchInvoiceVoList = Lists.newArrayList();
            List<Long> collect = releaseMsg.getDetailInfoList().stream().map(d -> d.getSalesBillId()).distinct().collect(Collectors.toList());
            String invoiceCode = releaseMsg.getInvoiceCode();
            String invoiceNo = releaseMsg.getInvoiceNo();
            Long invoiceId = releaseMsg.getInvoiceId();
            List<BillMatchInvoiceVo> billMatchInvoiceVos = this.matchInvoiceComponent.createVo(collect, invoiceId, invoiceNo, invoiceCode, invoiceOrigin = releaseMsg.getInvoiceOrigin(), tenantId);
            if (!CollectionUtils.isEmpty(billMatchInvoiceVos)) {
                billMatchInvoiceVoList.addAll(billMatchInvoiceVos);
            }
            if (!CollectionUtils.isEmpty((Collection)billMatchInvoiceVoList)) {
                this.matchInvoiceComponent.saveBillMatchInvoice(billMatchInvoiceVoList);
            }
        }
        billIds = billIds.stream().distinct().collect(Collectors.toList());
        HashMap map = Maps.newHashMap();
        map.put("groupId", userInfo.getGroupId());
        map.put("userId", userInfo.getUserId());
        map.put("userName", userInfo.getUserName());
        if (this.adapterIssuedOpen.booleanValue()) {
            this.updateOrderMakeApply(billIds, map);
        }
        return new ArrayList();
    }

    public String adapterName() {
        return "revertBillAndItem";
    }

    public void updateOrderMakeApply(List<Long> billIds, Map<String, Object> map) {
        this.rabbitmqService.send("phoenix_order_make_apply", JsonUtils.serialize(billIds), map);
    }
}

