/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.checker;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillItemVoMapper;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.phoenix.bill.client.model.MergeBillItemValidatePreviewRequest;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.xplatframework.model.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MergeBillItemValidatePreviewAdapter
implements IAdapter<AdapterParams, Object> {
    private static final int SOURCE_BILL_ITEM_MERGE_MIN_NUM = 2;
    private static final String SALESBILL_LIST_KEY = "ORD_SALESBILL_ENTITY_LIST";
    private static final String SALESBILL_ITEM_LIST_KEY = "ORD_SALESBILL_ITEM_ENTITY_LIST";
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private OrdSalesbillVoMapper ordSalesbillVoMapper;
    @Autowired
    private OrdSalesbillItemVoMapper ordSalesbillItemVoMapper;

    public Object process(AdapterParams adapterParams) {
        boolean isNegativeDi;
        MergeBillItemValidatePreviewRequest mergeBillItemValidatePreviewRequest = (MergeBillItemValidatePreviewRequest)adapterParams.getParams().get("mergeBillItemValidatePreviewRequest");
        if (Objects.isNull(mergeBillItemValidatePreviewRequest) || CollectionUtils.isEmpty((Collection)mergeBillItemValidatePreviewRequest.getSalesbillItemIdList())) {
            return Response.failed((String)"\u5408\u5e76\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        List itemIdList = mergeBillItemValidatePreviewRequest.getSalesbillItemIdList().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIdList) || itemIdList.size() < 2) {
            return Response.failed((String)"\u5f85\u5408\u5e76\u5355\u636e\u660e\u7ec6\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e2.");
        }
        if (null == mergeBillItemValidatePreviewRequest.getNegativeDiscountRule()) {
            return Response.failed((String)"\u8d1f\u6570\u884c\u6298\u6263\u89c4\u5219 \u4f20\u5165\u4e0d\u5408\u6cd5.");
        }
        if (mergeBillItemValidatePreviewRequest.getNegativeDiscountRule() > 2 || mergeBillItemValidatePreviewRequest.getNegativeDiscountRule() < 1) {
            return Response.failed((String)"\u8d1f\u6570\u884c\u6298\u6263\u89c4\u5219 \u4f20\u5165\u4e0d\u5408\u6cd5.");
        }
        boolean bl = isNegativeDi = mergeBillItemValidatePreviewRequest.getNegativeDiscountRule() != null && mergeBillItemValidatePreviewRequest.getNegativeDiscountRule() == 2;
        if (isNegativeDi && itemIdList.size() != 2) {
            return Response.failed((String)"\u8d1f\u6570\u884c\u6298\u6263\u89c4\u5219 \u5f53\u4e3a\u4ef7\u5916 \u660e\u7ec6\u6761\u6570\u5fc5\u987b\u4e3a2.");
        }
        com.xforceplus.receipt.vo.response.Response billItemResponse = this.billItemClient.queryBillItem(adapterParams.getTenantId(), itemIdList);
        if (billItemResponse.isOk()) {
            List billItems = (List)billItemResponse.getResult();
            if (billItems.stream().map(BillItem::getTaxRate).distinct().count() > 1L) {
                return Response.failed((String)"\u5f85\u5408\u5e76\u5355\u636e\u660e\u7ec6\u3010\u7a0e\u7387\u3011\u4e0d\u4e00\u81f4.");
            }
            List salesBillIdList = billItems.stream().filter(Objects::nonNull).map(BillItem::getBillId).distinct().collect(Collectors.toList());
            BillMainQueryRequest request = new BillMainQueryRequest();
            request.setBillIds(salesBillIdList);
            com.xforceplus.receipt.vo.response.Response listResponse = this.billMainClient.queryBills(adapterParams.getTenantId(), request);
            if (listResponse.isOk()) {
                HashMap salesbillMap = Maps.newHashMap();
                salesbillMap.put(SALESBILL_LIST_KEY, this.ordSalesbillVoMapper.mapToBillVos((List)listResponse.getResult()));
                salesbillMap.put(SALESBILL_ITEM_LIST_KEY, this.ordSalesbillItemVoMapper.mapToItemVoList(billItems));
                return Response.ok((String)"\u5408\u5e76\u6821\u9a8c\u6210\u529f.", (Object)salesbillMap);
            }
            return Response.failed((String)listResponse.getMessage());
        }
        return Response.failed((String)billItemResponse.getMessage());
    }

    public String adapterName() {
        return "mergeBillItemValidatePreview";
    }
}

