/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillItemVoMapper;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.vo.ReceiptSearchSort;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BIllMergeQueryItemAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillEsSearchClient billEsSearchClient;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Autowired
    private OrdSalesbillItemVoMapper ordSalesbillItemVoMapper;
    @Autowired
    private OrdSalesbillVoMapper ordSalesbillVoMapper;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        SearchModel searchModel = (SearchModel)params.get("billSearch");
        Long itemId = (Long)params.get("itemId");
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchModelUtil.mapFields((SearchModel)searchModel);
        SearchRequest searchRequest = this.searchModelMapper.mapToSearchRequest(searchModel);
        if (Objects.nonNull(itemId)) {
            searchRequest.setSearchAfters(Collections.singletonList(itemId));
        }
        request.setSearchModel(searchRequest);
        ReceiptSearchSort searchSort = BillGetBillListOptimizeAdapter.initSearchSorts(searchModel.getSort());
        request.getSearchModel().setSearchSort(searchSort);
        Response response = this.billEsSearchClient.itemEfficiency(adapterParams.getTenantId(), request);
        if (response.isOk()) {
            ResPageList pageList = (ResPageList)response.getResult();
            List itemVOS = pageList.getList();
            return itemVOS.stream().map(detailVo -> {
                OrdSalesbillDetailVO billDetailVo = new OrdSalesbillDetailVO();
                billDetailVo.setOrdSalesbillVO(this.ordSalesbillVoMapper.mapToBillVo(detailVo.getMain()));
                billDetailVo.setOrdSalesbillItemVO(this.ordSalesbillItemVoMapper.mapToItemVo(detailVo.getItem()));
                return billDetailVo;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String adapterName() {
        return "getEsSearchResponse";
    }
}

