/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.model.BillPageCountResponse;
import com.xforceplus.phoenix.bill.client.model.BillPageCountResult;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.xplatframework.model.Response;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillEsSearchCountAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillAdapterService adapterService;
    @Autowired
    private BillEsSearchClient esSearchClient;
    @Autowired
    private SearchModelMapper searchModelMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        BillSearchModel billSearchModel = (BillSearchModel)params.get("billSearchModel");
        SearchModel searchModel = this.adapterService.buildHasSearchModelForAdapter(billSearchModel);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        request.setSearchModel(this.searchModelMapper.mapToSearchRequest(searchModel));
        com.xforceplus.receipt.vo.response.Response response = this.esSearchClient.billElasticSearchCount(tenantId, request);
        ResPageList result = (ResPageList)response.getResult();
        if (response.isOk()) {
            BillPageCountResult countResult = new BillPageCountResult();
            countResult.setTotal(result.getTotal());
            countResult.setTotalAmountWithTax(result.getTotalAmountWithTax());
            countResult.setTotalAmountWithoutTax(result.getTotalAmountWithoutTax());
            countResult.setTotalDetailsCount(result.getTotalDetailsCount());
            countResult.setTotalBillCount(result.getTotalBillCount());
            countResult.setDiscountWithTaxTotal(result.getDiscountWithTaxTotal());
            countResult.setDiscountWithoutTaxTotal(result.getDiscountWithoutTaxTotal());
            return BillPageCountResponse.from((Integer)Response.OK, (String)response.getMessage(), (BillPageCountResult)countResult);
        }
        return BillPageCountResponse.from((Integer)Response.Fail, (String)response.getMessage());
    }

    public String adapterName() {
        return "countBill";
    }
}

