/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.enums.BillDisplayNameConvertEnum;
import com.xforceplus.adapter.mapstruct.BillItemMapper;
import com.xforceplus.adapter.mapstruct.BillMainMapper;
import com.xforceplus.adapter.mapstruct.BillUpdateItemExtMapper;
import com.xforceplus.adapter.mapstruct.BillUpdateMainExtMapper;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.model.ItemMapping;
import com.xforceplus.adapter.model.MainMapping;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.utils.ReflectUtil;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.BillOperationAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.model.ConfigRequestModel;
import com.xforceplus.phoenix.bill.client.api.adapter.model.SysConfigExtBean;
import com.xforceplus.phoenix.bill.client.enums.BillUpdateType;
import com.xforceplus.phoenix.bill.client.model.BillItemUpdateModel;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.vo.BillDetailVo;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.BillItemUpdateExt;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.BillMainUpdateExt;
import com.xforceplus.receipt.vo.BillUpdateSearchModel;
import com.xforceplus.receipt.vo.UserInfo;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.BillExtUpdateRequest;
import com.xforceplus.receipt.vo.request.BillItemAdjustRequest;
import com.xforceplus.receipt.vo.request.BillUpdateRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.config.client.constant.InvoiceType;
import com.xforceplus.seller.config.client.model.TaxNationalCode;
import com.xforceplus.seller.invoice.client.model.update.FieldAndValue;
import com.xforceplus.seller.invoice.client.model.update.UpdatePreInvoiceAndInvoiceExtFieldsRequest;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.v2.common.errors.BizRuntimeException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillUpdateAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillUpdateAdapter.class);
    @Autowired
    private BillUpdateClient updateClient;
    @Autowired
    private BillEsSearchClient esSearchClient;
    @Autowired
    private UserInfoHolder<com.xforceplus.xplatframework.apimodel.UserInfo> userInfoHolder;
    @Autowired
    private BillOperationAdapterService operationAdapterService;
    @Autowired
    private BillAdapterService billAdapterService;
    @Autowired
    private BillMainMapper mainMapper;
    @Autowired
    private BillItemMapper itemMapper;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Autowired
    private BillUpdateMainExtMapper mainExtMapper;
    @Autowired
    private BillUpdateItemExtMapper itemExtMapper;
    @Autowired
    private OrdSalesbillVoMapper ordSalesbillVoMapper;

    public Object process(AdapterParams adapterParams) {
        Set collect;
        List fields;
        Map map;
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        com.xforceplus.xplatframework.apimodel.UserInfo userInfo = (com.xforceplus.xplatframework.apimodel.UserInfo)this.userInfoHolder.get();
        BillItemUpdateModel updateModel = (BillItemUpdateModel)params.get("billItemUpdateModel");
        com.xforceplus.phoenix.bill.client.model.BillMain oldBillItems = updateModel.getOldBillItems();
        com.xforceplus.phoenix.bill.client.model.BillMain updateBillItems = updateModel.getUpdateBillItems();
        com.xforceplus.phoenix.bill.client.model.BillItem oldDetailItems = updateModel.getOldDetailItems();
        com.xforceplus.phoenix.bill.client.model.BillItem updateDetailItems = updateModel.getUpdateDetailItems();
        String objType = updateModel.getConditions().getBillType();
        if (Objects.nonNull(oldBillItems) && Objects.nonNull(updateBillItems)) {
            map = JsonUtils.parseMap((String)JsonUtils.serialize((Object)updateBillItems));
            fields = ReflectUtil.getFields(com.xforceplus.phoenix.bill.client.model.BillMain.class, new ArrayList(map.keySet()));
            this.setValueNullBak(updateBillItems, oldBillItems, fields);
        }
        if (Objects.nonNull(oldDetailItems) && Objects.nonNull(updateDetailItems)) {
            map = JsonUtils.parseMap((String)JsonUtils.serialize((Object)updateDetailItems));
            fields = ReflectUtil.getFields(com.xforceplus.phoenix.bill.client.model.BillItem.class, new ArrayList(map.keySet()));
            this.setValueNullBak(updateDetailItems, oldDetailItems, fields);
        }
        BillSearchModel billSearchModel = this.operationAdapterService.convertMakeoutInvoiceRequest2BillSearchModel(updateModel, null);
        SearchModel searchModel = this.billAdapterService.buildHasSearchModelForAdapter(billSearchModel);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        searchModel.setPageSize(Integer.valueOf(10000));
        String checkMessage = this.check(updateModel, searchModel, userInfo);
        log.info("updateCheckMessage:{}", (Object)checkMessage);
        if (StringUtils.isNotEmpty((CharSequence)checkMessage)) {
            return com.xforceplus.xplatframework.model.Response.failed((String)checkMessage);
        }
        String originInvoiceType = updateBillItems.getOriginInvoiceType();
        String originPaperDrawDate = updateBillItems.getOriginPaperDrawDate();
        HashMap map2 = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)originInvoiceType) && StringUtils.isNotEmpty((CharSequence)originPaperDrawDate)) {
            List<OrdSalesbillVO> billVos = this.getBillVo(searchModel, tenantId);
            if (CollectionUtils.isEmpty(billVos)) {
                return com.xforceplus.xplatframework.model.Response.failed((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5355\u6570\u636e!");
            }
            collect = billVos.stream().map(b -> b.getSellerTaxNo() + b.getPurchaserName()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                return com.xforceplus.xplatframework.model.Response.failed((String)"\u53ea\u80fd\u6279\u91cf\u4fee\u6539\u76f8\u540c\u8d2d\u9500\u65b9\u7684\u4e1a\u52a1\u5355!");
            }
            if (StringUtils.isNotEmpty((CharSequence)originInvoiceType) && StringUtils.isNotEmpty((CharSequence)originPaperDrawDate)) {
                for (OrdSalesbillVO ordSalesbillVO : billVos) {
                    com.xforceplus.xplatframework.model.Response checkResult = this.operationAdapterService.validateAndFillBillInvoiceCodeNo(updateBillItems, ordSalesbillVO);
                    if (!Objects.nonNull(checkResult)) continue;
                    return checkResult;
                }
            }
        }
        List businessObjMetadataBeans = this.operationAdapterService.queryMsMetadataItemList(Long.valueOf(userInfo.getGroupId()), objType);
        collect = businessObjMetadataBeans.stream().collect(Collectors.groupingBy(ms -> BillDisplayNameConvertEnum.find(ms.getFieldGroupIndex()), Collectors.toMap(mb -> {
            if (mb.getFieldGroupIndex() == 0) {
                return MainMapping.getField((String)mb.getFieldName());
            }
            return ItemMapping.getField((String)mb.getFieldName());
        }, ms -> ms.getFieldDisplayName())));
        HashMap modifyFieldMap = Maps.newHashMap();
        String amountWithoutTax = updateDetailItems.getAmountWithoutTax();
        String amountWithTax = updateDetailItems.getAmountWithTax();
        if (StringUtils.isNotEmpty((CharSequence)amountWithoutTax) || StringUtils.isNotEmpty((CharSequence)amountWithTax)) {
            log.info("--------------updateAmount------------");
            return this.adjustAmount(searchModel, tenantId, (Map<String, Map<String, String>>)((Object)collect), updateDetailItems);
        }
        log.info("----------update---------");
        return this.update(updateModel, tenantId, searchModel, (Map<String, Map<String, String>>)((Object)collect), map2, modifyFieldMap);
    }

    private Map<Long, String> getModifyInvoiceType(Boolean notZeroTaxRateAllowMakeCommonInvoice, Integer splitZeroTaxSpeBillFlag, List<BillItem> billItemList, String updateRate, StringBuilder errorMessage, Boolean confrimFlag) {
        HashMap map = Maps.newHashMap();
        for (BillItem billItem : billItemList) {
            BigDecimal taxRate = billItem.getTaxRate();
            String originInvoiceType = billItem.getInvoiceType();
            if ("0.00".equals(updateRate)) {
                if (splitZeroTaxSpeBillFlag != 2 && InvoiceType.SPECIAL.value().equals(originInvoiceType)) {
                    if (splitZeroTaxSpeBillFlag == 0) {
                        if (!confrimFlag.booleanValue()) {
                            errorMessage.append("\u53d1\u7968\u7c7b\u578b\u7531\u4e13\u7968\u8f6c\u4e3a\u666e\u7968\uff0c\u786e\u8ba4\u4fee\u6539\u5417\uff1f");
                            return null;
                        }
                        map.put(billItem.getId(), InvoiceType.NORMAL.value());
                    } else if (splitZeroTaxSpeBillFlag == 1) {
                        if (!confrimFlag.booleanValue()) {
                            errorMessage.append("\u53d1\u7968\u7c7b\u578b\u7531\u4e13\u7968\u8f6c\u4e3a\u7535\u7968\uff0c\u786e\u8ba4\u4fee\u6539\u5417\uff1f");
                            return null;
                        }
                        map.put(billItem.getId(), InvoiceType.ELECTRONIC.value());
                    }
                }
            } else if (!(taxRate == null || notZeroTaxRateAllowMakeCommonInvoice.booleanValue() || InvoiceType.SPECIAL.value().equals(originInvoiceType) || "se".equals(originInvoiceType))) {
                if (!confrimFlag.booleanValue()) {
                    errorMessage.append("\u53d1\u7968\u7c7b\u578b\u5c06\u8f6c\u4e3a\u4e13\u7968\uff0c\u786e\u8ba4\u4fee\u6539\u5417\uff1f");
                    return null;
                }
                map.put(billItem.getId(), InvoiceType.SPECIAL.value());
            }
            if (this.operationAdapterService.getBlueTaxRate().contains(updateRate)) continue;
            String formartTaxRate = new BigDecimal(updateRate).multiply(new BigDecimal(100)).setScale(0).toString() + "%";
            if (confrimFlag.booleanValue()) continue;
            errorMessage.append("\u7a0e\u7387\u3010" + formartTaxRate + "\u3011\u9700\u8981\u5411\u7a0e\u5c40\u7533\u8bf7\u8001\u7a0e\u7387\u5f00\u5177\u8d44\u8d28\u624d\u53ef\u5f00\u5177\uff0c\u786e\u8ba4\u4fee\u6539\u5417\uff1f");
            return null;
        }
        return map;
    }

    private List<BillItem> getBillItem(SearchModel searchModel, String tenantId) {
        ArrayList billItemList = Lists.newArrayList();
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest searchRequest = this.searchModelMapper.mapToSearchRequest(searchModel);
        searchRequest.setIncludes(Arrays.asList("id"));
        searchRequest.setPageSize(Integer.valueOf(2000));
        SearchSort sort = new SearchSort();
        sort.setFieldName("_id");
        sort.setSort("1");
        searchRequest.setSort(sort);
        request.setSearchModel(searchRequest);
        Response itemResultRes = this.esSearchClient.billItemElasticSearch(tenantId, request);
        ResPageList itemResult = (ResPageList)itemResultRes.getResult();
        if (Objects.isNull(itemResult) || CollectionUtils.isEmpty((Collection)itemResult.getList())) {
            return new ArrayList<BillItem>();
        }
        List itemList = itemResult.getList();
        Long itemId = ((BillDetailVo)itemList.get(itemList.size() - 1)).getItem().getId();
        Long itemTotalCount = itemResult.getTotalDetailsCount();
        billItemList.addAll(itemList.stream().map(BillDetailVo::getItem).collect(Collectors.toList()));
        Long page = itemTotalCount % 2000L == 0L ? itemTotalCount / 2000L - 1L : itemTotalCount / 2000L + 1L - 1L;
        for (long i = 0L; i < page; ++i) {
            searchRequest.setSearchAfters(Arrays.asList(itemId));
            itemResultRes = this.esSearchClient.billItemElasticSearch(tenantId, request);
            if (!Objects.nonNull(itemResultRes.getResult()) || CollectionUtils.isEmpty((Collection)((ResPageList)itemResultRes.getResult()).getList())) continue;
            itemList = ((ResPageList)itemResultRes.getResult()).getList();
            billItemList.addAll(itemList.stream().map(BillDetailVo::getItem).collect(Collectors.toList()));
            itemId = ((BillDetailVo)itemList.get(itemList.size() - 1)).getItem().getId();
        }
        return billItemList;
    }

    private SysConfigExtBean getSysConfig(OrdSalesbillVO ordSalesbillVO) {
        ConfigRequestModel configRequestModel = new ConfigRequestModel();
        BeanUtils.copyProperties((Object)ordSalesbillVO, (Object)configRequestModel);
        configRequestModel.setApiVersion(3);
        return this.operationAdapterService.querySysInfoConfig(configRequestModel);
    }

    private List<OrdSalesbillVO> getBillVo(SearchModel searchModel, String tenantId) {
        ArrayList billMains = Lists.newArrayList();
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest searchRequest = this.searchModelMapper.mapToSearchRequest(searchModel);
        searchRequest.setIncludes(Arrays.asList("id"));
        searchRequest.setPageSize(Integer.valueOf(2000));
        SearchSort sort = new SearchSort();
        sort.setFieldName("_id");
        sort.setSort("1");
        searchRequest.setSort(sort);
        request.setSearchModel(searchRequest);
        Response response = this.esSearchClient.billMainElasticSearch(tenantId, request);
        ResPageList result = (ResPageList)response.getResult();
        if (Objects.isNull(result) || CollectionUtils.isEmpty((Collection)result.getList())) {
            return new ArrayList<OrdSalesbillVO>();
        }
        List list = result.getList();
        Long mainId = ((BillMain)list.get(list.size() - 1)).getId();
        Long totalBillCount = result.getTotalBillCount();
        billMains.addAll(list);
        long page = totalBillCount % 2000L == 0L ? totalBillCount / 2000L - 1L : totalBillCount / 2000L + 1L - 1L;
        for (long i = 0L; i < page; ++i) {
            searchRequest.setSearchAfters(Arrays.asList(mainId));
            response = this.esSearchClient.billMainElasticSearch(tenantId, request);
            if (!Objects.nonNull(response.getResult()) || CollectionUtils.isEmpty((Collection)((ResPageList)response.getResult()).getList())) continue;
            List billMainList = ((ResPageList)response.getResult()).getList();
            billMains.addAll(billMainList);
            mainId = ((BillMain)billMainList.get(billMainList.size() - 1)).getId();
        }
        return this.ordSalesbillVoMapper.mapToBillVos(billMains);
    }

    private com.xforceplus.xplatframework.model.Response update(BillItemUpdateModel updateModel, String tenantId, SearchModel searchModel, Map<String, Map<String, String>> collect, Map<Long, String> map, Map<String, Set<String>> modifyFieldMap) {
        com.xforceplus.phoenix.bill.client.model.BillMain oldBillItems = updateModel.getOldBillItems();
        com.xforceplus.phoenix.bill.client.model.BillMain updateBillItems = updateModel.getUpdateBillItems();
        com.xforceplus.phoenix.bill.client.model.BillItem oldDetailItems = updateModel.getOldDetailItems();
        com.xforceplus.phoenix.bill.client.model.BillItem updateDetailItems = updateModel.getUpdateDetailItems();
        Integer billUpdateType = updateModel.getBillUpdateType();
        BillUpdateSearchModel billUpdateSearchModel = this.searchModelMapper.mapToUpdateSearchModel(searchModel);
        com.xforceplus.xplatframework.apimodel.UserInfo info = (com.xforceplus.xplatframework.apimodel.UserInfo)this.userInfoHolder.get();
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        if (BillUpdateType.MAIN.value() == billUpdateType.intValue()) {
            this.supplementItemGoods(updateModel);
            BillUpdateRequest request = new BillUpdateRequest();
            request.setSearchModel(billUpdateSearchModel);
            request.setConvertDisplayName(collect);
            request.setBillUpdateMain(this.mainMapper.map(updateBillItems));
            request.setBillUpdateItem(this.itemMapper.map(updateDetailItems));
            request.setOldBillUpdateMain(this.mainMapper.map(oldBillItems));
            request.setOldBillUpdateItem(this.itemMapper.map(oldDetailItems));
            request.setUserInfo(userInfo);
            request.setInvoiceMap(map);
            Response response = this.updateClient.update(tenantId, request);
            if (!response.isOk()) {
                return com.xforceplus.xplatframework.model.Response.failed((String)response.getMessage());
            }
            return com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage());
        }
        if (BillUpdateType.EXT.value() == billUpdateType.intValue()) {
            FieldAndValue fieldAndValue;
            BillExtUpdateRequest request = new BillExtUpdateRequest();
            BillMainUpdateExt mainUpdateExt = this.mainExtMapper.map(updateBillItems);
            BillItemUpdateExt itemUpdateExt = this.itemExtMapper.map(updateDetailItems);
            request.setItemUpdateExt(itemUpdateExt);
            request.setMainUpdateExt(mainUpdateExt);
            request.setSearchModel(billUpdateSearchModel);
            request.setUserInfo(userInfo);
            request.setConvertDisplayName(collect);
            Response response = this.updateClient.extUpdate(tenantId, request);
            if (!response.isOk()) {
                return com.xforceplus.xplatframework.model.Response.failed((String)response.getMessage());
            }
            UpdatePreInvoiceAndInvoiceExtFieldsRequest fieldsRequest = new UpdatePreInvoiceAndInvoiceExtFieldsRequest();
            Map itemMap = JsonUtils.parseMap((String)JsonUtils.serialize((Object)mainUpdateExt));
            Map detailMap = JsonUtils.parseMap((String)JsonUtils.serialize((Object)itemUpdateExt));
            if (!CollectionUtils.isEmpty((Map)itemMap)) {
                List<OrdSalesbillVO> billVo = this.getBillVo(searchModel, tenantId);
                if (CollectionUtils.isEmpty(billVo)) {
                    return com.xforceplus.xplatframework.model.Response.ok((String)"\u540c\u6b65\u6269\u5c55\u4fe1\u606f\u5230\u9884\u5236\u53d1\u7968\u5931\u8d25,\u67e5\u8be2\u4e3b\u6570\u636e\u5f02\u5e38!");
                }
                if (!CollectionUtils.isEmpty(billVo)) {
                    List billIds = billVo.stream().map(OrdSalesbillVO::getSalesbillId).collect(Collectors.toList());
                    ArrayList mains = Lists.newArrayList();
                    for (Map.Entry entry : itemMap.entrySet()) {
                        fieldAndValue = new FieldAndValue();
                        fieldAndValue.setFieldName((String)entry.getKey());
                        fieldAndValue.setFieldValue((String)entry.getValue());
                        mains.add(fieldAndValue);
                    }
                    fieldsRequest.setBillIds(billIds);
                    fieldsRequest.setMainFieldMessages((List)mains);
                }
            }
            if (!CollectionUtils.isEmpty((Map)detailMap)) {
                List<BillItem> billItem = this.getBillItem(searchModel, tenantId);
                if (CollectionUtils.isEmpty(billItem)) {
                    return com.xforceplus.xplatframework.model.Response.ok((String)"\u540c\u6b65\u6269\u5c55\u4fe1\u606f\u5230\u9884\u5236\u53d1\u7968\u5931\u8d25,\u67e5\u8be2\u660e\u7ec6\u6570\u636e\u5f02\u5e38!");
                }
                if (!CollectionUtils.isEmpty(billItem)) {
                    List itemIds = billItem.stream().map(BillItem::getId).collect(Collectors.toList());
                    ArrayList items = Lists.newArrayList();
                    for (Map.Entry entry : detailMap.entrySet()) {
                        fieldAndValue = new FieldAndValue();
                        fieldAndValue.setFieldName((String)entry.getKey());
                        fieldAndValue.setFieldValue((String)entry.getValue());
                        items.add(fieldAndValue);
                    }
                    fieldsRequest.setBillItemIds(itemIds);
                    fieldsRequest.setItemFieldMessages((List)items);
                }
            }
            log.info("updatePreInvoiceRequest:{}", (Object)JsonUtils.serialize((Object)fieldsRequest));
            com.xforceplus.xplatframework.model.Response preResponse = this.operationAdapterService.updatePreInvoiceAndInvoiceExtFields(fieldsRequest);
            if (preResponse.getCode().intValue() != com.xforceplus.xplatframework.model.Response.OK.intValue()) {
                throw new BizRuntimeException().setMessage(response.getMessage());
            }
            return com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage());
        }
        return com.xforceplus.xplatframework.model.Response.ok((String)"\u4fee\u6539\u6210\u529f!");
    }

    private com.xforceplus.xplatframework.model.Response adjustAmount(SearchModel searchModel, String tenantId, Map<String, Map<String, String>> collect, com.xforceplus.phoenix.bill.client.model.BillItem updateDetailItems) {
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest searchRequest = this.searchModelMapper.mapToSearchRequest(searchModel);
        searchRequest.setPageSize(Integer.valueOf(1));
        request.setSearchModel(searchRequest);
        Response response = this.esSearchClient.billItemElasticSearch(tenantId, request);
        ResPageList result = (ResPageList)response.getResult();
        if (!response.isOk() || Objects.isNull(response.getResult()) || CollectionUtils.isEmpty((Collection)result.getList())) {
            return com.xforceplus.xplatframework.model.Response.failed((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25!");
        }
        List list = result.getList();
        if (list.size() > 1) {
            return com.xforceplus.xplatframework.model.Response.failed((String)"\u91d1\u989d\u53d7\u5f71\u54cd\u7684\u660e\u7ec6\u6761\u6570\u4e0d\u80fd\u5927\u4e8e\u4e00\u6761");
        }
        com.xforceplus.xplatframework.apimodel.UserInfo info = (com.xforceplus.xplatframework.apimodel.UserInfo)this.userInfoHolder.get();
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        BillDetailVo billDetailVo = (BillDetailVo)list.get(0);
        ConfigRequestModel configRequestModel = new ConfigRequestModel();
        BeanUtils.copyProperties((Object)this.ordSalesbillVoMapper.mapToBillVo(billDetailVo.getMain()), (Object)configRequestModel);
        configRequestModel.setApiVersion(3);
        SysConfigExtBean sysInfoRuleDTO = this.operationAdapterService.querySysInfoConfig(configRequestModel);
        BigDecimal billTolerance = Objects.isNull(sysInfoRuleDTO) || Objects.isNull(sysInfoRuleDTO.getBillTolerance()) ? BigDecimal.ZERO : sysInfoRuleDTO.getBillTolerance();
        BillItemAdjustRequest adjustRequest = new BillItemAdjustRequest();
        adjustRequest.setItemId(billDetailVo.getItem().getId());
        if (Objects.nonNull(updateDetailItems.getAmountWithTax())) {
            adjustRequest.setAmount(new BigDecimal(updateDetailItems.getAmountWithTax()));
        }
        if (Objects.nonNull(updateDetailItems.getAmountWithoutTax())) {
            adjustRequest.setAmountWithOut(new BigDecimal(updateDetailItems.getAmountWithoutTax()));
        }
        adjustRequest.setConvertDisplayName(collect);
        adjustRequest.setTolerance(billTolerance);
        adjustRequest.setUserInfo(userInfo);
        Response adjustResult = this.updateClient.itemAmountAdjust(tenantId, adjustRequest);
        if (!adjustResult.isOk()) {
            return com.xforceplus.xplatframework.model.Response.failed((String)adjustResult.getMessage());
        }
        return com.xforceplus.xplatframework.model.Response.ok((String)adjustResult.getMessage());
    }

    private String check(BillItemUpdateModel updateModel, SearchModel searchModel, com.xforceplus.xplatframework.apimodel.UserInfo userInfo) {
        HashSet billItemSet;
        int updateDetailItemsHashCode;
        String message = "";
        com.xforceplus.phoenix.bill.client.model.BillMain oldBillItems = updateModel.getOldBillItems();
        com.xforceplus.phoenix.bill.client.model.BillMain updateBillItems = updateModel.getUpdateBillItems();
        com.xforceplus.phoenix.bill.client.model.BillItem oldDetailItems = updateModel.getOldDetailItems();
        com.xforceplus.phoenix.bill.client.model.BillItem updateDetailItems = updateModel.getUpdateDetailItems();
        int oldBillItemsHashCode = Objects.nonNull(oldBillItems) ? oldBillItems.hashCode() : 0;
        int updateBillItemsHashCode = Objects.nonNull(updateBillItems) ? updateBillItems.hashCode() : 0;
        int oldDetailItemsHashCode = Objects.nonNull(oldDetailItems) ? oldDetailItems.hashCode() : 0;
        int n = updateDetailItemsHashCode = Objects.nonNull(updateDetailItems) ? updateDetailItems.hashCode() : 0;
        if (oldBillItemsHashCode == updateBillItemsHashCode && oldDetailItemsHashCode == updateDetailItemsHashCode) {
            message = "\u672a\u83b7\u53d6\u9700\u8981\u4fee\u6539\u7684\u6570\u636e\u5b57\u6bb5\u5185\u5bb9!";
            return message;
        }
        HashSet billMainSet = Sets.newHashSet();
        com.xforceplus.xplatframework.model.Response checkBeforeUpdateResult = this.operationAdapterService.checkBillMainBeforeUpdate((Set)billMainSet, (Set)(billItemSet = Sets.newHashSet()), updateModel, updateModel.getConditions().getBillType(), Long.valueOf(userInfo.getGroupId()));
        if (checkBeforeUpdateResult.getCode() == 0) {
            message = checkBeforeUpdateResult.getMessage();
            return message;
        }
        return null;
    }

    public String adapterName() {
        return "updateBatch";
    }

    public com.xforceplus.xplatframework.model.Response supplementItemGoods(BillItemUpdateModel billItemUpdateModel) {
        com.xforceplus.phoenix.bill.client.model.BillItem updateDetailItems = billItemUpdateModel.getUpdateDetailItems();
        Map map = JsonUtils.parseMap((String)JsonUtils.serialize((Object)updateDetailItems));
        if (!StringUtils.isEmpty((CharSequence)billItemUpdateModel.getUpdateDetailItems().getGoodsId())) {
            TaxNationalCode taxNationalCode;
            this.operationAdapterService.convertToRealGoods(billItemUpdateModel);
            updateDetailItems = billItemUpdateModel.getUpdateDetailItems();
            String goodsTaxNo = updateDetailItems.getGoodsTaxNo();
            if (!StringUtils.isEmpty((CharSequence)goodsTaxNo) && (taxNationalCode = this.operationAdapterService.getNationalTaxCode(goodsTaxNo)) != null) {
                updateDetailItems.setGoodsNoVer(taxNationalCode.getVersion());
                updateDetailItems.setItemShortName(taxNationalCode.getTaxcodeShortName());
                updateDetailItems.setSplitCode(taxNationalCode.getSplitCode());
            }
        } else {
            if (Objects.nonNull(map.get("taxRate"))) {
                if (!StringUtils.isEmpty((CharSequence)updateDetailItems.getUnitPrice()) || !StringUtils.isEmpty((CharSequence)updateDetailItems.getUnitPriceWithTax())) {
                    return com.xforceplus.xplatframework.model.Response.failed((String)"\u4fee\u6539\u7a0e\u7387\u540c\u65f6,\u4e0d\u5141\u8bb8\u4fee\u6539\u5355\u4ef7");
                }
                if (!StringUtils.isEmpty((CharSequence)updateDetailItems.getQuantity())) {
                    return com.xforceplus.xplatframework.model.Response.failed((String)"\u4fee\u6539\u7a0e\u7387\u540c\u65f6,\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
                }
            }
            if (!StringUtils.isEmpty((CharSequence)billItemUpdateModel.getUpdateDetailItems().getItemName())) {
                updateDetailItems.setItemName(billItemUpdateModel.getUpdateDetailItems().getItemName());
            }
            if (!StringUtils.isEmpty((CharSequence)updateDetailItems.getGoodsTaxNo())) {
                TaxNationalCode taxNationalCode = this.operationAdapterService.getNationalTaxCode(updateDetailItems.getGoodsTaxNo());
                if (Objects.isNull(taxNationalCode) || Strings.isEmpty((CharSequence)taxNationalCode.getGoodsTaxNo())) {
                    return com.xforceplus.xplatframework.model.Response.failed((String)"\u4e0d\u5408\u6cd5\u7684\u7a0e\u6536\u7f16\u7801");
                }
                if (1 != taxNationalCode.getEndFlag()) {
                    return com.xforceplus.xplatframework.model.Response.failed((String)"\u7a0e\u6536\u7f16\u53f7\u672a\u5230\u672b\u7ea7");
                }
                updateDetailItems.setGoodsNoVer(taxNationalCode.getVersion());
                updateDetailItems.setItemShortName(taxNationalCode.getTaxcodeShortName());
                updateDetailItems.setSplitCode(taxNationalCode.getSplitCode());
            }
        }
        return null;
    }

    public void setValueNullBak(Object o, Object oldObject, List<Field> fields) {
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object newField = field.get(o);
                Object oldField = null;
                if (Objects.nonNull(oldObject)) {
                    oldField = field.get(oldObject);
                }
                if (!Objects.nonNull(newField) || !Objects.nonNull(oldField) || !newField.toString().equals(oldField.toString())) continue;
                field.set(o, null);
                field.set(oldObject, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

