/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.InvoiceBillItemMapper;
import com.xforceplus.phoenix.bill.client.model.BillQueryItemResponse;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillItem;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BIllItemByIdQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BIllItemByIdQueryAdapter.class);
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private InvoiceBillItemMapper invoiceBillItemMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Long billId = (Long)adapterParams.getParams().get("billId");
        Response response = this.billItemClient.queryBillItemByBillId(adapterParams.getTenantId(), Collections.singletonList(billId));
        BillQueryItemResponse itemResponse = new BillQueryItemResponse();
        if (response.isOk() && !CollectionUtils.isEmpty((Collection)((Collection)response.getResult()))) {
            List<InvoiceBillItem> invoiceBillItems = this.invoiceBillItemMapper.mapToInvoiceBillItems((List)response.getResult());
            itemResponse.setResult(invoiceBillItems);
            itemResponse.setCode(BillQueryItemResponse.OK);
            itemResponse.setMessage(response.getMessage());
        } else {
            itemResponse.setCode(BillQueryItemResponse.Fail);
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u5931\u8d25:{},{}", (Object)billId, (Object)response.getMessage());
            itemResponse.setMessage("\u672a\u67e5\u8be2\u5230\u5355\u636e\u5bf9\u5e94\u7684\u660e\u7ec6\u4fe1\u606f");
        }
        return itemResponse;
    }

    public String adapterName() {
        return "queryBillItemById";
    }
}

