/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillItemVoMapper;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.model.ItemMapping;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.model.BillDetailResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.vo.ReceiptSearchSort;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillGetBillListByDetailOptimizeAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillGetBillListByDetailOptimizeAdapter.class);
    @Autowired
    private BillEsSearchClient esSearchClient;
    @Autowired
    private OrdSalesbillVoMapper billVoMapper;
    @Autowired
    private OrdSalesbillItemVoMapper itemVoMapper;
    @Autowired
    private SearchModelMapper searchModelMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        BillSearchModel billSearchModel = (BillSearchModel)params.get("billSearchModel");
        SearchModel searchModel = (SearchModel)params.get("searchModel");
        SearchModelUtil.mapFields((SearchModel)searchModel);
        if (Objects.nonNull(searchModel.getSort())) {
            BillGetBillListByDetailOptimizeAdapter.mappingItemSortField(searchModel.getSort());
        }
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        request.setRequestSource(Integer.valueOf(billSearchModel.getRequestSource()));
        request.setSearchModel(this.searchModelMapper.mapToSearchRequest(searchModel));
        ReceiptSearchSort searchSort = BillGetBillListOptimizeAdapter.initSearchSorts(searchModel.getSort());
        request.getSearchModel().setSearchSort(searchSort);
        Response resPageListResponse = this.esSearchClient.billItemElasticSearch(tenantId, request);
        ResPageList result = (ResPageList)resPageListResponse.getResult();
        ResPageList pageList = new ResPageList();
        pageList.setTotalDetailsCount(result.getTotalDetailsCount());
        pageList.setTotalBillCount(result.getTotalBillCount());
        pageList.setTotal(result.getTotal());
        pageList.setTotalAmountWithTax(result.getTotalAmountWithTax());
        pageList.setTotalAmountWithoutTax(result.getTotalAmountWithoutTax());
        List collect = result.getList().stream().map(detailVo -> {
            OrdSalesbillDetailVO billDetailVo = new OrdSalesbillDetailVO();
            billDetailVo.setOrdSalesbillVO(this.billVoMapper.mapToBillVo(detailVo.getMain()));
            billDetailVo.setOrdSalesbillItemVO(this.itemVoMapper.mapToItemVo(detailVo.getItem()));
            return billDetailVo;
        }).collect(Collectors.toList());
        pageList.setList(collect);
        return BillDetailResponse.from((Integer)BillDetailResponse.OK, (String)"\u67e5\u8be2\u6210\u529f", (ResPageList)pageList);
    }

    public static void mappingItemSortField(SearchSort sort) {
        sort.setFieldName(ItemMapping.getField((String)sort.getFieldName()));
        if (!CollectionUtils.isEmpty((Collection)sort.getSearchSort())) {
            for (SearchSort searchSort : sort.getSearchSort()) {
                BillGetBillListByDetailOptimizeAdapter.mappingItemSortField(searchSort);
            }
        }
        if (Objects.nonNull(sort.getMainSort())) {
            SearchSort mainSort = sort.getMainSort();
            mainSort.setFieldName(ItemMapping.getField((String)sort.getFieldName()));
        }
    }

    public String adapterName() {
        return "getBillListByDetailOptimize";
    }
}

