/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.save;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillDetailClient;
import com.xforceplus.adapter.core.client.ReceiptSalesBillDetailClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.ReceiptBillItemMapper;
import com.xforceplus.adapter.mapstruct.ReceiptBillMainMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.vo.BillConvertItem;
import com.xforceplus.adapter.vo.BillConvertMain;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.receipt.vo.BillDetail;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.PushInfo;
import com.xforceplus.receipt.vo.request.BillDetailRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.enums.BillSystemOrigin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MakeSalesBillAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(MakeSalesBillAdapter.class);
    @Autowired
    private ReceiptBillMainMapper billMainMapper;
    @Autowired
    private ReceiptBillItemMapper billItemMapper;
    @Autowired
    private BillDetailClient detailClient;
    @Autowired
    ReceiptSalesBillDetailClient receiptSalesBillDetailClient;
    @Autowired
    private BillAdapterService adapterService;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        List billConvertMains = JsonUtils.parseList((String)JsonUtils.serialize(params.get("billMains")), BillConvertMain.class);
        List billConvertItems = JsonUtils.parseList((String)JsonUtils.serialize(params.get("billItems")), BillConvertItem.class);
        String groupId = String.valueOf(params.get("groupId"));
        Map headerMap = (Map)params.get("headers");
        billConvertMains.stream().forEach(billMain -> {
            if (BillSystemOrigin.IMPORT.value().equals(billMain.getSystemOrig())) {
                billMain.setSystemOrigType(1);
            } else {
                billMain.setSystemOrigType(0);
            }
        });
        Map<Long, List<BillConvertItem>> collect = billConvertItems.stream().collect(Collectors.groupingBy(item -> item.getSalesbillId()));
        List billDetails = billConvertMains.stream().map(billConvertMain -> {
            List<BillItem> billItemList = this.billItemMapper.mapToBillItems((List)collect.get(billConvertMain.getSalesbillId()));
            BillMain billMain = this.billMainMapper.mapToBillMain((BillConvertMain)billConvertMain);
            BillDetail billDetail = new BillDetail();
            billDetail.setItems(billItemList);
            billDetail.setMain(billMain);
            return billDetail;
        }).collect(Collectors.toList());
        BillDetailRequest billDetailRequest = new BillDetailRequest();
        billDetailRequest.setBillDetails(billDetails);
        PushInfo pushInfo = new PushInfo();
        pushInfo.setPushFlag(Boolean.valueOf(true));
        billDetailRequest.setPushInfo(pushInfo);
        Response response = this.receiptSalesBillDetailClient.addBillDetails(tenantId, billDetailRequest);
        HashMap map = Maps.newHashMap();
        if (response.isOk()) {
            HashMap hashMap = Maps.newHashMap();
            ((List)response.getResult()).stream().forEach(item -> hashMap.put(item.getOriginBillId(), item.getBillId()));
            map.put("midIdToPlateformId", hashMap);
            map.put("successMains", params.get("billMains"));
            map.put("successItems", params.get("billItems"));
        } else {
            List longs = billConvertMains.stream().map(BillConvertMain::getSalesbillId).collect(Collectors.toList());
            map.put("failSalesBillIds", longs);
            this.adapterService.handleExist(response.getMessage(), longs);
        }
        return map;
    }

    public String adapterName() {
        return "makeSalesBill";
    }
}

