/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.enums.BillDisplayNameConvertEnum;
import com.xforceplus.phoenix.bill.client.api.adapter.BillOperationAdapterService;
import com.xforceplus.phoenix.bill.client.model.BillItemTaxCodeUpdateModel;
import com.xforceplus.phoenix.bill.client.model.UpdateCommonResponse;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.vo.BillUpdateItem;
import com.xforceplus.receipt.vo.BillUpdateSearchModel;
import com.xforceplus.receipt.vo.request.BillUpdateRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.config.client.model.TaxNationalCode;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UpdateBatchTaxCodeAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(UpdateBatchTaxCodeAdapter.class);
    @Autowired
    private BillUpdateClient updateClient;
    @Autowired
    private BillOperationAdapterService adapterService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        BillItemTaxCodeUpdateModel model = (BillItemTaxCodeUpdateModel)params.get("updateModel");
        if (CollectionUtils.isEmpty((Collection)model.getItemIds())) {
            return UpdateCommonResponse.failed((String)"\u88ab\u4fee\u6539\u660e\u7ec6\u6570\u636e\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BillUpdateRequest request = new BillUpdateRequest();
        BillUpdateSearchModel searchModel = new BillUpdateSearchModel();
        searchModel.setPageSize(Integer.valueOf(10000));
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setValue(model.getItemIds());
        searchFilter.setFieldName("id");
        searchFilter.setFieldQueryType(Operator.checkbox);
        searchModel.setChildGroups(Arrays.asList(Arrays.asList(searchFilter)));
        BillUpdateItem billItem = new BillUpdateItem();
        billItem.setGoodsTaxNo(model.getGoodsTaxNo());
        billItem.setTaxPre(model.getTaxPre());
        billItem.setTaxPreCon(model.getTaxPreCon());
        billItem.setZeroTax(model.getZeroTax());
        TaxNationalCode taxNationalCode = this.adapterService.getNationalTaxCode(model.getGoodsTaxNo());
        if (taxNationalCode != null) {
            billItem.setGoodsNoVer(taxNationalCode.getVersion());
            billItem.setItemShortName(taxNationalCode.getTaxcodeShortName());
            billItem.setSplitCode(taxNationalCode.getSplitCode());
        }
        UserInfo info = (UserInfo)this.userInfoHolder.get();
        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        request.setBillUpdateItem(billItem);
        request.setUserInfo(userInfo);
        request.setSearchModel(searchModel);
        HashMap collect = Maps.newHashMap();
        HashMap mainMap = Maps.newHashMap();
        mainMap.put("goodsNoVer", "\u7f16\u7801\u7248\u672c\u53f7");
        mainMap.put("itemShortName", "\u7b80\u79f0");
        mainMap.put("splitCode", "\u662f\u5426\u53ef\u4ee5\u6df7\u5f00");
        mainMap.put("goodsTaxNo", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
        mainMap.put("taxPre", "\u4eab\u53d7\u4f18\u60e0\u653f\u7b56");
        mainMap.put("taxPreCon", "\u4f18\u60e0\u653f\u7b56\u5185\u5bb9");
        mainMap.put("zeroTax", "\u96f6\u7a0e\u7387\u6807\u8bc6");
        collect.put(BillDisplayNameConvertEnum.ITEM.receiptType(), mainMap);
        request.setConvertDisplayName((Map)collect);
        Response update = this.updateClient.update(tenantId, request);
        if (update.isOk()) {
            return UpdateCommonResponse.from((Integer)BaseResponse.OK, (String)"\u5546\u54c1\u7a0e\u7f16\u7f16\u8f91\u6210\u529f!");
        }
        return UpdateCommonResponse.from((Integer)BaseResponse.Fail, (String)"\u5546\u54c1\u7a0e\u7f16\u7f16\u8f91\u5931\u8d25!");
    }

    public String adapterName() {
        return "updateBatchTaxCode";
    }
}

