/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.enums.BillDisplayNameConvertEnum;
import com.xforceplus.phoenix.bill.client.model.UpdateInvoiceTitleRequest;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.vo.BillUpdateMain;
import com.xforceplus.receipt.vo.BillUpdateSearchModel;
import com.xforceplus.receipt.vo.request.BillUpdateRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateInvoiceTitleAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(UpdateInvoiceTitleAdapter.class);
    @Autowired
    private BillUpdateClient updateClient;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        UpdateInvoiceTitleRequest titleRequest = (UpdateInvoiceTitleRequest)params.get("request");
        List salesbillId = titleRequest.getSalesbillId();
        BillUpdateRequest request = new BillUpdateRequest();
        BillUpdateSearchModel searchModel = new BillUpdateSearchModel();
        searchModel.setPageSize(Integer.valueOf(10000));
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setValue(salesbillId);
        searchFilter.setFieldName("id");
        searchFilter.setFieldQueryType(Operator.checkbox);
        searchModel.setGroups(Arrays.asList(Arrays.asList(searchFilter)));
        request.setSearchModel(searchModel);
        BillUpdateMain billMain = new BillUpdateMain();
        billMain.setSellerAddress(titleRequest.getSellerAddress());
        billMain.setSellerBankAccount(titleRequest.getSellerBankAccount());
        billMain.setSellerBankName(titleRequest.getSellerBankName());
        billMain.setSellerTel(titleRequest.getSellerTel());
        UserInfo info = (UserInfo)this.userInfoHolder.get();
        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        request.setBillUpdateMain(billMain);
        request.setUserInfo(userInfo);
        request.setSearchModel(searchModel);
        HashMap collect = Maps.newHashMap();
        HashMap mainMap = Maps.newHashMap();
        mainMap.put("sellerAddress", "\u9500\u65b9\u5730\u5740");
        mainMap.put("sellerBankAccount", "\u9500\u65b9\u94f6\u884c\u5e10\u53f7");
        mainMap.put("sellerBankName", "\u9500\u65b9\u94f6\u884c\u540d\u79f0");
        mainMap.put("sellerTel", "\u9500\u65b9\u7535\u8bdd");
        collect.put(BillDisplayNameConvertEnum.MAIN.receiptType(), mainMap);
        request.setConvertDisplayName((Map)collect);
        Response update = this.updateClient.update(tenantId, request);
        if (update.isOk()) {
            return com.xforceplus.xplatframework.model.Response.from((Integer)BaseResponse.OK, (String)"\u62ac\u5934\u4fee\u6539\u6210\u529f!");
        }
        return com.xforceplus.xplatframework.model.Response.from((Integer)BaseResponse.Fail, (String)"\u62ac\u5934\u4fee\u6539\u5931\u8d25!");
    }

    public String adapterName() {
        return "updateInvoiceTitle";
    }
}

