/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.mapstruct;

import com.xforceplus.adapter.mapstruct.BillItemMapper;
import com.xforceplus.phoenix.bill.client.model.BillItem;
import com.xforceplus.receipt.vo.BillItemExt;
import com.xforceplus.receipt.vo.BillUpdateItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class BillItemMapperImpl
implements BillItemMapper {
    @Override
    public BillUpdateItem map(BillItem billItem) {
        if (billItem == null) {
            return null;
        }
        BillUpdateItem billUpdateItem = new BillUpdateItem();
        billUpdateItem.setInvoiceType(billItem.getInvoiceType());
        billUpdateItem.setItemCode(billItem.getItemCode());
        billUpdateItem.setItemName(billItem.getItemName());
        billUpdateItem.setSplitCode(billItem.getSplitCode());
        billUpdateItem.setItemShortName(billItem.getItemShortName());
        billUpdateItem.setItemSpec(billItem.getItemSpec());
        if (billItem.getUnitPriceWithTax() != null) {
            billUpdateItem.setUnitPriceWithTax(new BigDecimal(billItem.getUnitPriceWithTax()));
        }
        if (billItem.getUnitPrice() != null) {
            billUpdateItem.setUnitPrice(new BigDecimal(billItem.getUnitPrice()));
        }
        if (billItem.getQuantity() != null) {
            billUpdateItem.setQuantity(new BigDecimal(billItem.getQuantity()));
        }
        billUpdateItem.setQuantityUnit(billItem.getQuantityUnit());
        if (billItem.getAmountWithTax() != null) {
            billUpdateItem.setAmountWithTax(new BigDecimal(billItem.getAmountWithTax()));
        }
        if (billItem.getAmountWithoutTax() != null) {
            billUpdateItem.setAmountWithoutTax(new BigDecimal(billItem.getAmountWithoutTax()));
        }
        if (billItem.getTaxAmount() != null) {
            billUpdateItem.setTaxAmount(new BigDecimal(billItem.getTaxAmount()));
        }
        if (billItem.getTaxRate() != null) {
            billUpdateItem.setTaxRate(new BigDecimal(billItem.getTaxRate()));
        }
        billUpdateItem.setTaxPre(billItem.getTaxPre());
        billUpdateItem.setTaxPreCon(billItem.getTaxPreCon());
        billUpdateItem.setZeroTax(billItem.getZeroTax());
        billUpdateItem.setGoodsTaxNo(billItem.getGoodsTaxNo());
        billUpdateItem.setTaxConvertCode(billItem.getTaxConvertCode());
        billUpdateItem.setGoodsNoVer(billItem.getGoodsNoVer());
        billUpdateItem.setRemark(billItem.getRemark());
        this.serializeBillItemExt(billItem, billUpdateItem);
        return billUpdateItem;
    }

    @Override
    public List<BillUpdateItem> mapList(List<BillItem> billItems) {
        if (billItems == null) {
            return null;
        }
        ArrayList<BillUpdateItem> list = new ArrayList<BillUpdateItem>(billItems.size());
        for (BillItem billItem : billItems) {
            list.add(this.map(billItem));
        }
        return list;
    }

    @Override
    public BillItemExt billItemMapToExt(BillItem billMain) {
        if (billMain == null) {
            return null;
        }
        BillItemExt billItemExt = new BillItemExt();
        billItemExt.setLargeCategoryName(billMain.getLargeCategoryName());
        billItemExt.setMedianCategoryName(billMain.getMedianCategoryName());
        billItemExt.setSmallCategoryName(billMain.getSmallCategoryName());
        billItemExt.setExt1(billMain.getExt1());
        billItemExt.setExt2(billMain.getExt2());
        billItemExt.setExt3(billMain.getExt3());
        billItemExt.setExt4(billMain.getExt4());
        billItemExt.setExt5(billMain.getExt5());
        billItemExt.setExt6(billMain.getExt6());
        billItemExt.setExt7(billMain.getExt7());
        billItemExt.setExt8(billMain.getExt8());
        billItemExt.setExt9(billMain.getExt9());
        billItemExt.setExt10(billMain.getExt10());
        billItemExt.setExt11(billMain.getExt11());
        billItemExt.setExt12(billMain.getExt12());
        billItemExt.setExt13(billMain.getExt13());
        billItemExt.setExt14(billMain.getExt14());
        billItemExt.setExt15(billMain.getExt15());
        billItemExt.setExt16(billMain.getExt16());
        billItemExt.setExt17(billMain.getExt17());
        billItemExt.setExt18(billMain.getExt18());
        billItemExt.setExt19(billMain.getExt19());
        billItemExt.setExt20(billMain.getExt20());
        return billItemExt;
    }
}

