/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.receipt.utils;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.enums.Operator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDateUtils {
    private static final Logger log = LoggerFactory.getLogger(SearchDateUtils.class);

    public static String checkSearchTimeRange(List<Long> createTime) {
        if (Objects.isNull(createTime) || createTime.isEmpty()) {
            return "\u8bf7\u8f93\u5165\u9700\u8981\u641c\u7d22\u67e5\u8be2\u7684\u65f6\u95f4\u8303\u56f4";
        }
        Long startTime = createTime.get(0);
        Long endTime = createTime.get(1);
        if (startTime > endTime) {
            log.info("\u67e5\u8be2\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u67e5\u8be2\u7ec8\u6b62\u65f6\u95f4:\u8d77\u70b9\u65f6\u95f4={},\u7ec8\u70b9\u65f6\u95f4={}", (Object)startTime, (Object)endTime);
            return "\u67e5\u8be2\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u67e5\u8be2\u7ec8\u6b62\u65f6\u95f4";
        }
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(startTime);
        instance.set(instance.get(1) + 1, instance.get(2), instance.get(5), 23, 59, 59);
        long rangeTime = instance.getTimeInMillis();
        if (endTime > rangeTime) {
            log.info("\u67e5\u8be2\u8d77\u59cb\u65f6\u95f4\u548c\u67e5\u8be2\u7ec8\u6b62\u65f6\u95f4\u7684\u8303\u56f4\u4e0d\u80fd\u5927\u4e8e\u4e00\u5e74:\u67e5\u8be2\u7ec8\u70b9\u65f6\u95f4={},\u67e5\u8be2\u8303\u56f4\u6700\u5927\u65f6\u95f4={}", (Object)endTime, (Object)rangeTime);
            return "\u67e5\u8be2\u8d77\u59cb\u65f6\u95f4\u548c\u67e5\u8be2\u7ec8\u6b62\u65f6\u95f4\u7684\u8303\u56f4\u4e0d\u80fd\u5927\u4e8e\u4e00\u5e74";
        }
        return null;
    }

    public static SearchFilter initDateRange(List<Long> createTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+0800");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(createTime.get(0));
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        long startTime = calendar.getTimeInMillis();
        calendar.setTimeInMillis(createTime.get(1));
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) + 1, 0, 0, 0);
        long endTime = calendar.getTimeInMillis();
        log.info("startTime={},endTime={}", (Object)startTime, (Object)endTime);
        return new SearchFilter("createTime", (List)Lists.newArrayList((Object[])new Long[]{startTime, endTime}), Operator.range);
    }
}

