/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.receipt.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xforceplus.receipt.dto.merge.AbstractMergeConfig;
import com.xforceplus.receipt.dto.merge.config.KeepPriceMergeConfig;
import com.xforceplus.receipt.dto.merge.config.NegativeOffsetConfig;
import com.xforceplus.receipt.dto.merge.config.NegativeToInnerDiscountMergeConfig;
import com.xforceplus.receipt.dto.merge.config.NegativeToOuterDiscountMergeConfig;
import com.xforceplus.receipt.dto.merge.config.NoQuantityAndPriceMergeConfig;
import com.xforceplus.receipt.dto.merge.config.QuantityAddMergeConfig;
import com.xforceplus.receipt.dto.merge.config.QuantityToOneMergeConfig;
import com.xforceplus.receipt.enums.FunctionFlag;
import com.xforceplus.receipt.exception.ReceiptRuntimeException;
import io.swagger.annotations.ApiModel;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@ApiModel
public class MergeConfigAssembly {
    @NotNull
    private String functionName;
    private NegativeOffsetConfig negativeOffsetConfig;
    private KeepPriceMergeConfig keepPriceMergeConfig;
    private NegativeToInnerDiscountMergeConfig negativeToInnerDiscountMergeConfig;
    private NegativeToOuterDiscountMergeConfig negativeToOuterDiscountMergeConfig;
    private QuantityAddMergeConfig quantityAddMergeConfig;
    private QuantityToOneMergeConfig quantityToOneMergeConfig;
    private NoQuantityAndPriceMergeConfig noQuantityAndPriceMergeConfig;
    private transient Map<String, AbstractMergeConfig> mergeConfigMap = new HashMap<String, AbstractMergeConfig>();

    public MergeConfigAssembly() {
    }

    public MergeConfigAssembly(AbstractMergeConfig mergeConfig) {
        this.setFunction(mergeConfig);
    }

    public AbstractMergeConfig getMergeConfig() {
        return this.mergeConfigMap.get(this.functionName);
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
        FunctionFlag functionFlag = FunctionFlag.fromName(functionName);
        if (functionFlag != null) {
            try {
                this.mergeConfigMap.put(this.functionName, functionFlag.getMergeConfig().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ReceiptRuntimeException("\u7b97\u5b50:[" + this.functionName + "]\u521d\u59cb\u5316\u5931\u8d25\u3002");
            }
        }
    }

    @JsonIgnore
    public void setFunction(AbstractMergeConfig mergeConfig) {
        this.functionName = mergeConfig.getFunctionName();
        this.mergeConfigMap.putIfAbsent(this.functionName, mergeConfig);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public NegativeOffsetConfig getNegativeOffsetConfig() {
        return this.negativeOffsetConfig;
    }

    public KeepPriceMergeConfig getKeepPriceMergeConfig() {
        return this.keepPriceMergeConfig;
    }

    public NegativeToInnerDiscountMergeConfig getNegativeToInnerDiscountMergeConfig() {
        return this.negativeToInnerDiscountMergeConfig;
    }

    public NegativeToOuterDiscountMergeConfig getNegativeToOuterDiscountMergeConfig() {
        return this.negativeToOuterDiscountMergeConfig;
    }

    public QuantityAddMergeConfig getQuantityAddMergeConfig() {
        return this.quantityAddMergeConfig;
    }

    public QuantityToOneMergeConfig getQuantityToOneMergeConfig() {
        return this.quantityToOneMergeConfig;
    }

    public NoQuantityAndPriceMergeConfig getNoQuantityAndPriceMergeConfig() {
        return this.noQuantityAndPriceMergeConfig;
    }

    public Map<String, AbstractMergeConfig> getMergeConfigMap() {
        return this.mergeConfigMap;
    }

    public void setNegativeOffsetConfig(NegativeOffsetConfig negativeOffsetConfig) {
        this.negativeOffsetConfig = negativeOffsetConfig;
    }

    public void setKeepPriceMergeConfig(KeepPriceMergeConfig keepPriceMergeConfig) {
        this.keepPriceMergeConfig = keepPriceMergeConfig;
    }

    public void setNegativeToInnerDiscountMergeConfig(NegativeToInnerDiscountMergeConfig negativeToInnerDiscountMergeConfig) {
        this.negativeToInnerDiscountMergeConfig = negativeToInnerDiscountMergeConfig;
    }

    public void setNegativeToOuterDiscountMergeConfig(NegativeToOuterDiscountMergeConfig negativeToOuterDiscountMergeConfig) {
        this.negativeToOuterDiscountMergeConfig = negativeToOuterDiscountMergeConfig;
    }

    public void setQuantityAddMergeConfig(QuantityAddMergeConfig quantityAddMergeConfig) {
        this.quantityAddMergeConfig = quantityAddMergeConfig;
    }

    public void setQuantityToOneMergeConfig(QuantityToOneMergeConfig quantityToOneMergeConfig) {
        this.quantityToOneMergeConfig = quantityToOneMergeConfig;
    }

    public void setNoQuantityAndPriceMergeConfig(NoQuantityAndPriceMergeConfig noQuantityAndPriceMergeConfig) {
        this.noQuantityAndPriceMergeConfig = noQuantityAndPriceMergeConfig;
    }

    public void setMergeConfigMap(Map<String, AbstractMergeConfig> mergeConfigMap) {
        this.mergeConfigMap = mergeConfigMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeConfigAssembly)) {
            return false;
        }
        MergeConfigAssembly other = (MergeConfigAssembly)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        NegativeOffsetConfig this$negativeOffsetConfig = this.getNegativeOffsetConfig();
        NegativeOffsetConfig other$negativeOffsetConfig = other.getNegativeOffsetConfig();
        if (this$negativeOffsetConfig == null ? other$negativeOffsetConfig != null : !this$negativeOffsetConfig.equals(other$negativeOffsetConfig)) {
            return false;
        }
        KeepPriceMergeConfig this$keepPriceMergeConfig = this.getKeepPriceMergeConfig();
        KeepPriceMergeConfig other$keepPriceMergeConfig = other.getKeepPriceMergeConfig();
        if (this$keepPriceMergeConfig == null ? other$keepPriceMergeConfig != null : !((Object)this$keepPriceMergeConfig).equals(other$keepPriceMergeConfig)) {
            return false;
        }
        NegativeToInnerDiscountMergeConfig this$negativeToInnerDiscountMergeConfig = this.getNegativeToInnerDiscountMergeConfig();
        NegativeToInnerDiscountMergeConfig other$negativeToInnerDiscountMergeConfig = other.getNegativeToInnerDiscountMergeConfig();
        if (this$negativeToInnerDiscountMergeConfig == null ? other$negativeToInnerDiscountMergeConfig != null : !this$negativeToInnerDiscountMergeConfig.equals(other$negativeToInnerDiscountMergeConfig)) {
            return false;
        }
        NegativeToOuterDiscountMergeConfig this$negativeToOuterDiscountMergeConfig = this.getNegativeToOuterDiscountMergeConfig();
        NegativeToOuterDiscountMergeConfig other$negativeToOuterDiscountMergeConfig = other.getNegativeToOuterDiscountMergeConfig();
        if (this$negativeToOuterDiscountMergeConfig == null ? other$negativeToOuterDiscountMergeConfig != null : !this$negativeToOuterDiscountMergeConfig.equals(other$negativeToOuterDiscountMergeConfig)) {
            return false;
        }
        QuantityAddMergeConfig this$quantityAddMergeConfig = this.getQuantityAddMergeConfig();
        QuantityAddMergeConfig other$quantityAddMergeConfig = other.getQuantityAddMergeConfig();
        if (this$quantityAddMergeConfig == null ? other$quantityAddMergeConfig != null : !((Object)this$quantityAddMergeConfig).equals(other$quantityAddMergeConfig)) {
            return false;
        }
        QuantityToOneMergeConfig this$quantityToOneMergeConfig = this.getQuantityToOneMergeConfig();
        QuantityToOneMergeConfig other$quantityToOneMergeConfig = other.getQuantityToOneMergeConfig();
        if (this$quantityToOneMergeConfig == null ? other$quantityToOneMergeConfig != null : !((Object)this$quantityToOneMergeConfig).equals(other$quantityToOneMergeConfig)) {
            return false;
        }
        NoQuantityAndPriceMergeConfig this$noQuantityAndPriceMergeConfig = this.getNoQuantityAndPriceMergeConfig();
        NoQuantityAndPriceMergeConfig other$noQuantityAndPriceMergeConfig = other.getNoQuantityAndPriceMergeConfig();
        return !(this$noQuantityAndPriceMergeConfig == null ? other$noQuantityAndPriceMergeConfig != null : !((Object)this$noQuantityAndPriceMergeConfig).equals(other$noQuantityAndPriceMergeConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MergeConfigAssembly;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        NegativeOffsetConfig $negativeOffsetConfig = this.getNegativeOffsetConfig();
        result = result * 59 + ($negativeOffsetConfig == null ? 43 : $negativeOffsetConfig.hashCode());
        KeepPriceMergeConfig $keepPriceMergeConfig = this.getKeepPriceMergeConfig();
        result = result * 59 + ($keepPriceMergeConfig == null ? 43 : ((Object)$keepPriceMergeConfig).hashCode());
        NegativeToInnerDiscountMergeConfig $negativeToInnerDiscountMergeConfig = this.getNegativeToInnerDiscountMergeConfig();
        result = result * 59 + ($negativeToInnerDiscountMergeConfig == null ? 43 : $negativeToInnerDiscountMergeConfig.hashCode());
        NegativeToOuterDiscountMergeConfig $negativeToOuterDiscountMergeConfig = this.getNegativeToOuterDiscountMergeConfig();
        result = result * 59 + ($negativeToOuterDiscountMergeConfig == null ? 43 : $negativeToOuterDiscountMergeConfig.hashCode());
        QuantityAddMergeConfig $quantityAddMergeConfig = this.getQuantityAddMergeConfig();
        result = result * 59 + ($quantityAddMergeConfig == null ? 43 : ((Object)$quantityAddMergeConfig).hashCode());
        QuantityToOneMergeConfig $quantityToOneMergeConfig = this.getQuantityToOneMergeConfig();
        result = result * 59 + ($quantityToOneMergeConfig == null ? 43 : ((Object)$quantityToOneMergeConfig).hashCode());
        NoQuantityAndPriceMergeConfig $noQuantityAndPriceMergeConfig = this.getNoQuantityAndPriceMergeConfig();
        result = result * 59 + ($noQuantityAndPriceMergeConfig == null ? 43 : ((Object)$noQuantityAndPriceMergeConfig).hashCode());
        return result;
    }

    public String toString() {
        return "MergeConfigAssembly(functionName=" + this.getFunctionName() + ", negativeOffsetConfig=" + this.getNegativeOffsetConfig() + ", keepPriceMergeConfig=" + this.getKeepPriceMergeConfig() + ", negativeToInnerDiscountMergeConfig=" + this.getNegativeToInnerDiscountMergeConfig() + ", negativeToOuterDiscountMergeConfig=" + this.getNegativeToOuterDiscountMergeConfig() + ", quantityAddMergeConfig=" + this.getQuantityAddMergeConfig() + ", quantityToOneMergeConfig=" + this.getQuantityToOneMergeConfig() + ", noQuantityAndPriceMergeConfig=" + this.getNoQuantityAndPriceMergeConfig() + ", mergeConfigMap=" + this.getMergeConfigMap() + ")";
    }
}

