/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.receipt.vo.response;

import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Page;

public class PageResp<T> {
    private List<T> rows;
    private Summary summary;

    public static <T> PageResp<T> from(Page<T> page) {
        PageResp<T> pageResp = new PageResp<T>();
        Summary summary = new Summary();
        summary.setTotal(page.getTotalElements());
        summary.setPages(page.getTotalPages());
        pageResp.setRows(page.getContent());
        pageResp.setSummary(summary);
        return pageResp;
    }

    public static <T> PageResp<T> of(long total, List<T> rows) {
        PageResp<T> pageResp = new PageResp<T>();
        Summary summary = new Summary();
        summary.setTotal(total);
        if (rows == null) {
            pageResp.setRows(Collections.emptyList());
        } else {
            pageResp.setRows(rows);
        }
        pageResp.setSummary(summary);
        return pageResp;
    }

    public void setPages(int pages) {
        if (this.summary == null) {
            this.summary = new Summary();
        }
        this.summary.setPages(pages);
    }

    public void setTotal(long total) {
        if (this.summary == null) {
            this.summary = new Summary();
        }
        this.summary.setTotal(total);
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public static class Summary {
        private long total;
        private int pages;

        public long getTotal() {
            return this.total;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public int getPages() {
            return this.pages;
        }

        public void setPages(int pages) {
            this.pages = pages;
        }
    }
}

