/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.receipt.vo.response;

public class Response<T> {
    public static final String OK = "RECEIPT000";
    public static final String Fail = "RECEIPT001";
    public static final String PARAMS_ERROR = "RECEIPT400";
    private String code;
    private String message;
    private T result;

    public static Response ok(String message) {
        Response response = new Response();
        response.setCode(OK);
        response.setMessage(message);
        return response;
    }

    public static <T> Response okWithEmptyMessage(T result) {
        Response<T> response = new Response<T>();
        response.setCode(OK);
        response.setMessage("");
        response.setResult(result);
        return response;
    }

    public static <T> Response ok(String message, T result) {
        Response<T> response = new Response<T>();
        response.setCode(OK);
        response.setMessage(message);
        response.result = result;
        return response;
    }

    public static Response failed(String message) {
        Response response = new Response();
        response.setCode(Fail);
        response.setMessage(message);
        return response;
    }

    public static Response from(String code, String message) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static <T> Response<T> from(String code, String message, T result) {
        Response<T> response = new Response<T>();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }
}

