/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.receipt.enums;

import com.xforceplus.receipt.exception.IllegalArgumentsException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExternalFunctionChannel {
    HTTP("http://"),
    HTTPS("https://"),
    HTTP_ASYNC("http://"),
    HTTPS_ASYNC("https://"),
    SQS("");

    private static final Logger log;
    private String prefix;

    private ExternalFunctionChannel(String prefix) {
        this.prefix = prefix;
    }

    public void validateDestination(String destination) {
        boolean startsWith;
        if (this.prefix.length() > 0 && !(startsWith = destination.toLowerCase().startsWith(this.prefix))) {
            log.info("\u5916\u7f6e\u7b97\u5b50\u5730\u5740/\u961f\u5217\u5e94\u4ee5[{}]\u5f00\u5934", (Object)this.prefix);
            throw new IllegalArgumentsException("\u5916\u7f6e\u7b97\u5b50\u5730\u5740/\u961f\u5217\u5e94\u4ee5[" + this.prefix + "]\u5f00\u5934");
        }
    }

    public static ExternalFunctionChannel validateAndGet(String channel) {
        return Arrays.stream(ExternalFunctionChannel.values()).filter(x -> x.name().equalsIgnoreCase(channel)).findFirst().orElseThrow(() -> {
            log.info("\u901a\u9053[{}]\u4e0d\u5408\u6cd5\uff0c\u5e94\u4e3a:[HTTP,HTTPS,HTTP_ASYNC,HTTPS_ASYNC,SQS]\u5176\u4e2d\u4e4b\u4e00", (Object)channel);
            return new IllegalArgumentsException("\u901a\u9053[" + channel + "]\u4e0d\u5408\u6cd5\uff0c\u5e94\u4e3a:[HTTP,HTTPS,HTTP_ASYNC,HTTPS_ASYNC,SQS]\u5176\u4e2d\u4e4b\u4e00");
        });
    }

    static {
        log = LoggerFactory.getLogger(ExternalFunctionChannel.class);
    }
}

