/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.receipt.dto.config.merge;

import com.xforceplus.receipt.dto.config.AbstractMergeConfig;
import com.xforceplus.receipt.enums.ForbidNegativeEnum;
import com.xforceplus.receipt.enums.MergeOffsetRuleEnum;
import com.xforceplus.receipt.enums.NegativePartitionEnum;
import com.xforceplus.receipt.enums.NegativeRuleEnum;
import com.xforceplus.receipt.exception.IllegalArgumentReceiptException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DefaultMergeRuleConfig
extends AbstractMergeConfig {
    private static final List<String> mergeRules = Arrays.asList("KEEP_PRICE", "QUANTITY_ADD", "QUANTITY_MERGE_TO_ONE", "NO_QUANTITY_NO_PRICE");
    private NegativeRuleEnum negativeRule;
    private NegativePartitionEnum negativePartitionRule;
    private ForbidNegativeEnum forbidNegative;
    private MergeOffsetRuleEnum offsetRule;
    private String mergeRule;

    public DefaultMergeRuleConfig() {
    }

    public DefaultMergeRuleConfig(NegativeRuleEnum negativeRule) {
        this.negativeRule = negativeRule;
    }

    public void setMergeRule(String mergeRule) {
        if (Objects.isNull(mergeRule)) {
            throw new IllegalArgumentReceiptException("\u7f3a\u5c11\u5408\u5e76\u89c4\u5219[mergeRule]");
        }
        if (!mergeRules.contains(mergeRule)) {
            throw new IllegalArgumentReceiptException("\u4f20\u5165\u7684\u5408\u5e76\u89c4\u5219[" + mergeRule + "]\u4e0d\u6b63\u786e,\u5e94\u4e3a:KEEP_PRICE,QUANTITY_ADD,QUANTITY_MERGE_TO_ONE,NO_QUANTITY_NO_PRICE");
        }
        this.mergeRule = mergeRule;
    }

    public void setNegativeRule(NegativeRuleEnum negativeRule) {
        this.negativeRule = negativeRule;
    }

    public void setNegativePartitionRule(NegativePartitionEnum negativePartitionRule) {
        this.negativePartitionRule = negativePartitionRule;
    }

    public void setForbidNegative(ForbidNegativeEnum forbidNegative) {
        this.forbidNegative = forbidNegative;
    }

    public void setOffsetRule(MergeOffsetRuleEnum offsetRule) {
        this.offsetRule = offsetRule;
    }

    public NegativeRuleEnum getNegativeRule() {
        return this.negativeRule;
    }

    public NegativePartitionEnum getNegativePartitionRule() {
        return this.negativePartitionRule;
    }

    public ForbidNegativeEnum getForbidNegative() {
        return this.forbidNegative;
    }

    public MergeOffsetRuleEnum getOffsetRule() {
        return this.offsetRule;
    }

    public String getMergeRule() {
        return this.mergeRule;
    }

    public String toString() {
        return "DefaultMergeRuleConfig(negativeRule=" + (Object)((Object)this.getNegativeRule()) + ", negativePartitionRule=" + (Object)((Object)this.getNegativePartitionRule()) + ", forbidNegative=" + (Object)((Object)this.getForbidNegative()) + ", offsetRule=" + (Object)((Object)this.getOffsetRule()) + ", mergeRule=" + this.getMergeRule() + ")";
    }
}

