/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.receipt.vo.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class Response<T> {
    private String code;
    private String message;
    private T result;
    public static final String FAILED = "RECEIPT001";
    public static final String OK = "RECEIPT000";

    public static Response ok(String message) {
        Response response = new Response();
        response.setCode(OK);
        response.setMessage(message);
        return response;
    }

    public static <T> Response<T> okWithEmptyMessage(T result) {
        Response<T> response = new Response<T>();
        response.setCode(OK);
        response.setMessage("");
        response.setResult(result);
        return response;
    }

    public static <T> Response<T> ok(String message, T result) {
        Response<T> response = new Response<T>();
        response.setCode(OK);
        response.setMessage(message);
        response.result = result;
        return response;
    }

    public static Response failed(String message) {
        return Response.failed(message, FAILED);
    }

    public static Response failed(String message, String code) {
        Response response = new Response();
        response.setCode(Objects.nonNull(code) ? code : FAILED);
        response.setMessage(message);
        return response;
    }

    public static Response from(String code, String message) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static <T> Response<T> from(String code, String message, T result) {
        Response<T> response = new Response<T>();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }

    @JsonIgnore
    public boolean isOk() {
        return Objects.equals(OK, this.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }
}

