package com.xforceplus.phoenix.recog.api;

import com.xforceplus.phoenix.recog.api.model.MsRecResponse;
import com.xforceplus.phoenix.recog.api.model.batch.*;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author chong
 */
@Api(value = "recBatchApi", description = "识别服务批次相关api")
public interface RecBatchApi {

    @ApiOperation(value = "获取批次id", notes = "获取批次id", response = MsFetchBatchIdResponse.class, tags = {"recBatchApi"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFetchBatchIdResponse.class)})
    /**
     * 获取批次id
     *
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApi/redidsTest", method = RequestMethod.POST)
    MsRecResponse<String> redisTest();

    /**
     * 获取批次id
     * @param request
     * @return
     */
    @ApiOperation(value = "获取批次id", notes = "获取批次id", response = MsFetchBatchIdResponse.class, tags = {"recBatchApi"})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsFetchBatchIdResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApi/fetchBatchId", method = RequestMethod.POST)
    MsFetchBatchIdResponse fetchBatchId(@ApiParam(name = "", value = "json格式", required = true)
            @RequestBody MsFetchBatchIdRequest request);

    @ApiOperation(value = "查找批次", notes = "查找批次", response = MsRecResponse.class, tags = {"recBatchApi"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 查找批次
     *
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApi/findBatch", method = RequestMethod.POST)
    MsRecResponse<List<BatchInfoDto>> findBatch(@ApiParam(name = "查找批次请求参数", value = "json格式", required = true)
                                                @RequestBody MsFindBatchRequest request);

    @ApiOperation(value = "完成批次", notes = "完成批次", response = MsCompleteBatchResponse.class, tags = {"recBatchApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsCompleteBatchResponse.class)})
    /**
     * 完成批次
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApia/completeBatch", method = RequestMethod.POST)
    MsCompleteBatchResponse completeBatch(@ApiParam(name = "完成批次请求参数", value = "json格式", required = true)
                                          @RequestBody MsCompleteBatchRequest request);

    @ApiOperation(value = "完成批次Job", notes = "完成批次Job", tags = {"recBatchApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回")})
    /**
     * 完成批次
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApia/completeBatchJob", method = RequestMethod.POST)
    void completeBatchJob();


    @ApiOperation(value = "查找未识别的数量", notes = "查找未识别的数量", response = MsFindUnRecogCountResponse.class, tags = {"recBatchApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFindUnRecogCountResponse.class)})
    /**
     * 查找未识别的数量
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApi/findUnRecogCount", method = RequestMethod.POST)
    public MsFindUnRecogCountResponse findUnRecogCount(@ApiParam(name = "查找未识别的数量请求参数", value = "json格式", required = true)
                                                       @RequestBody MsFindUnRecogCountRequest request);

    @ApiOperation(value = "查找未识别的Level1数量请求参数", notes = "查找未识别的Level1数量请求参数", response = MsFindUnRecogLevel1CountResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"recBatchApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFindUnRecogLevel1CountResponse.class)})
    /**
     * 查找第一级序列未识别的数量
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApi/findUnRecogLevel1Count", method = RequestMethod.POST)
    MsFindUnRecogLevel1CountResponse findUnRecogLevel1Count(@ApiParam(name = "查找未识别的Level1数量请求参数", value = "json格式", required = true)
                                                            @RequestBody MsFindUnRecogLevel1CountRequest request);
}
