package com.xforceplus.phoenix.recog.api;

import com.xforceplus.phoenix.recog.api.model.MsRecResponse;
import com.xforceplus.phoenix.recog.api.model.file.*;
import com.xforceplus.phoenix.recog.api.model.invoice.MsDownLoadRequest;
import com.xforceplus.phoenix.recog.api.model.invoice.MsDownLoadResponse;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author chong
 */
public interface RecFileApi {
    /**
     * 新文件上传
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "扫描文件上传", notes = "扫描文件上传", response = MsFileUploadResponse.class, tags = {"recFileApi"})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsFileUploadResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/uploadFile",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsFileUploadResponse uploadFile(@ApiParam @RequestBody MsFileUploadRequest request);

    /**
     * 新文件上传
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "批量新批次文件上传", notes = "批量新批次文件上传", response = MsRecResponse.class, tags = {"recFileApi"})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/uploadFiles",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsRecResponse<Void> uploadFiles(@ApiParam @RequestBody MsFilesUploadRequest request);


    @ApiOperation(value = "文件插入上传", notes = "文件插入上传", response = MsFileUploadResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFileUploadResponse.class)})
    /**
     * 文件插入上传
     * <p>
     * 用于在某一文件树种插入上传一个文件
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/insertFile", method = RequestMethod.POST)
    MsFileUploadResponse insertFile(@ApiParam @RequestBody MsFileUploadRequest request);

    @ApiOperation(value = "批量文件插入上传", notes = "批量文件插入上传", response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 批量文件插入上传
     * <p>
     * 用于在某一文件树种插入上传一个文件
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/insertFiles", method = RequestMethod.POST)
    MsRecResponse<Void> insertFiles(@ApiParam @RequestBody MsFilesInsertRequest request);


    @ApiOperation(value = "文件追加上传", notes = "文件追加上传", response = MsFileUploadResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFileUploadResponse.class)})
    /**
     * 文件追加上传
     * <p>
     * 用于在某一文件树的最后面追加一个文件
     *
     * @param file
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/appendFile", method = RequestMethod.POST)
    MsFileUploadResponse appendFile(@ApiParam @RequestBody MsFileAppendRequest request);


    @ApiOperation(value = "文件层级调整", notes = "文件层级调整", response = MsReGenerateHierarchyResponse0.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsReGenerateHierarchyResponse0.class)})
    /**
     * 文件层级调整
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/reGenerateHierarchy0", method = RequestMethod.POST)
    @Deprecated
    MsReGenerateHierarchyResponse0 reGenerateHierarchy0(@ApiParam(name = "文件层级调整请求参数", value = "json格式", required = true)
                                                        @RequestBody MsReGenerateHierarchyRequest0 request);

    @ApiOperation(value = "文件层级调整", notes = "文件层级调整", response = MsReGenerateHierarchyResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsReGenerateHierarchyResponse.class)})

    /**
     * 文件层级调整
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/reGenerateHierarchy", method = RequestMethod.POST)
    MsReGenerateHierarchyResponse reGenerateHierarchy(@ApiParam(name = "文件层级调整请求参数", value = "json格式", required = true)
                                                      @RequestBody MsReGenerateHierarchyRequest request);


    @ApiOperation(value = "根据批次调整层级关系", notes = "根据批次调整层级关系", response = MsGenerateBatchHierarchyResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsGenerateBatchHierarchyResponse.class)})
    /**
     * 根据批次调整层级关系（仅限未完成的批次）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/generateBatchHierarchy", method = RequestMethod.POST)
    MsGenerateBatchHierarchyResponse generateBatchHierarchy(@ApiParam(name = "", value = "json格式", required = true)
                                                            @RequestBody MsGenerateBatchHierarchyRequest request);


    @ApiOperation(value = "根据批次调整层级关系", notes = "根据批次调整层级关系", response = MsGenerateLevel1HierarchyResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsGenerateLevel1HierarchyResponse.class)})

    /**
     * 根据第一级调整层级关系
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/generateLevel1Hierarchy", method = RequestMethod.POST)
    MsGenerateLevel1HierarchyResponse generateLevel1Hierarchy(@ApiParam(name = "", value = "json格式", required = true)
                                                              @RequestBody MsGenerateLevel1HierarchyRequest request);


    /**
     * 查询待提交文件
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "查询待提交文件", notes = "查询待提交文件", response = MsFindUnSubmitFilesResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsFindUnSubmitFilesResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findUnSubmitFiles", method = RequestMethod.POST)
    MsFindUnSubmitFilesResponse findUnSubmitFiles(@ApiParam(name = "查询待提交文件请求参数", value = "json格式", required = true)
                                                  @RequestBody MsFindUnSubmitFilesRequest request);


    /**
     * 查询已提交文件
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "查询已提交文件", notes = "查询已提交文件", response = MsFindSubmittedFilesResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsFindSubmittedFilesResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findSubmittedFiles", method = RequestMethod.POST)
    MsFindSubmittedFilesResponse findSubmittedFiles(@ApiParam(name = "查询已提交文件请求参数", value = "json格式", required = true)
                                                    @RequestBody MsFindSubmittedFilesRequest request);


    @ApiOperation(value = "查询左侧文件列表", notes = "查询左侧文件列表", response = MsFindLeftFilesResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFindLeftFilesResponse.class)})
    /**
     * 查询左侧文件列表
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findLeftFiles", method = RequestMethod.POST)
    MsFindLeftFilesResponse findLeftFiles(@ApiParam(name = "查询左侧文件列表请求参数", value = "json格式", required = true)
                                          @RequestBody MsFindLeftFilesRequest request);


    @ApiOperation(value = "根据文件id查找重复文件", notes = "根据文件id查找重复文件", response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 根据文件id查找重复文件
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findRepeatFiles", method = RequestMethod.POST)
    MsRecResponse<List<List<FileInfoDto>>> findRepeatFiles(@ApiParam(name = "", value = "json格式", required = true)
                                                           @RequestBody MsFindRepeatFilesRequest request);


    @ApiOperation(value = "查找文件", notes = "查找文件", response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 查找文件
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findFile", method = RequestMethod.POST)
    MsRecResponse<List<FileInfoDto>> findFile(@ApiParam(name = "", value = "json格式", required = true) @RequestBody MsFindFileRequest request);


    @ApiOperation(value = "查找发票文件（发票管理特定服务）", notes = "查找发票文件（发票管理特定服务）",
            response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 查找发票文件（发票管理特定服务）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findPimInvoiceFile", method = RequestMethod.POST)
    MsRecResponse<MsRecogPimInvoiceFileInfo> findPimInvoiceFile(@ApiParam(name = "", value = "json格式", required = true)
                                                                @RequestBody MsFindPimInvoiceFileRequest request);


    @ApiOperation(value = "删除文件", notes = "删除文件", response = MsFileDeleteResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFileDeleteResponse.class)})
    /**
     * 删除文件
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/deleteFile", method = RequestMethod.POST)
    MsFileDeleteResponse deleteFile(@ApiParam(name = "删除文件请求参数", value = "json格式", required = true)
                                    @RequestBody MsFileDeleteRequest request);

    @ApiOperation(value = "提交全部待提交文件", notes = "提交全部待提交文件", response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 提交全部待提交文件
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/submit", method = RequestMethod.POST)
    MsRecResponse<Void> submit(@ApiParam(name = "文件提交请求参数", value = "json格式", required = true)
                               @RequestBody MsSubmitRequest request);


    @ApiOperation(value = "按批次待提交文件", notes = "按批次待提交文件", response = MsFileSubmitResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFileSubmitResponse.class)})
    /**
     * 按批次待提交文件
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/submitFile", method = RequestMethod.POST)
    MsFileSubmitResponse submitFile(@ApiParam(name = "文件提交请求参数", value = "json格式", required = true)
                                    @RequestBody MsFileSubmitRequest request);


    @ApiOperation(value = "已提交文件再次提交", notes = "已提交文件再次提交", response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 已提交文件再次提交
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/submitFiles", method = RequestMethod.POST)
    MsRecResponse<Void> submitFiles(@ApiParam(name = "文件提交请求参数", value = "json格式", required = true)
                                    @RequestBody MsFilesSubmitRequest request);


    @ApiOperation(value = "拉取提交结果Job", notes = "拉取提交结果Job", tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回")})
    /**
     * 拉取提交结果Job
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/fetchSubmitResultJob", method = RequestMethod.POST)
    void fetchSubmitResultJob();


    @ApiOperation(value = "文件统计信息", notes = "文件统计信息", response = MsFindStatResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsFindStatResponse.class)})
    /**
     * 文件统计信息
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findStat", method = RequestMethod.POST)
    MsFindStatResponse findStat(@ApiParam @RequestBody MsFindStatRequest request);

    /**
     * @param request
     * @return
     */
    @ApiOperation(value = "查询提交处理情况", notes = "查询提交处理情况", response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/submitProcess", method = RequestMethod.POST)
    MsRecResponse<SubmitProcessDto> submitProcess(@ApiParam @RequestBody MsSubmitProcessRequest request);


    /**
     * 下载文件列表
     *
     * @param request
     * @return
     */

    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/downLoadFiles", method = RequestMethod.POST)
    MsDownLoadResponse downLoadFiles(@ApiParam @RequestBody MsDownLoadRequest request);

    /**
     * 轮询redis查询待提交文件
     *
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findUnSubmitFilesByRedis", method = RequestMethod.POST)
    MsFindUnSubmitFilesResponse findUnSubmitFilesByRedis(@ApiParam(name = "轮询redis查询待提交文件请求参数", value = "json格式", required = true)
                                                         @RequestBody MsFindUnSubmitFilesRequest request);

    /**
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/getFileDetail", method = RequestMethod.POST)
    MsRecResponse<FileDetailDto> getFileDetail(@ApiParam(name = "查询文件详情", value = "json格式", required = true) @RequestBody MsGetFileDetailRequest request);

    /**
     * 查找发票文件集合（发票管理特定服务）
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "查找发票文件集合（发票管理特定服务）", notes = "查找发票文件集合（发票管理特定服务）",
            response = MsRecResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/findPimInvoiceFileList", method = RequestMethod.POST)
    MsRecResponse<List<MsRecogPimInvoiceFileInfo>> findPimInvoiceFileList(@ApiParam(name = "", value = "json格式", required = true)
                                                                @RequestBody MsFindPimInvoiceFileRequest request);


    /**
     * 校验数据权限
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "校验数据权限", notes = "校验数据权限）",
            response = MsGetDataPermissionResponse.class, tags = {"recFileApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsGetDataPermissionResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recFileApi/getDataPermission", method = RequestMethod.POST)
    MsGetDataPermissionResponse getDataPermission(@ApiParam(name = "", value = "json格式", required = true)
                                                                          @RequestBody MsGetDataPermissionRequest request);

}
