package com.xforceplus.phoenix.recog.api.model;

import com.xforceplus.phoenix.recog.api.common.Response;
import com.xforceplus.phoenix.recog.api.constant.MsResponseCode;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @author chong
 */
@ApiModel
@Data
public class MsRecResponse<T> extends Response<T> {
    public MsRecResponse() {
        this.setCode(Response.OK);
        this.setMessage("ok");
    }

    public boolean isOk(MsRecResponse response) {
        return MsResponseCode.OK.equals(response.getCode());
    }

    public MsRecResponse<T> ok() {
        this.setCode(Response.OK);
        return this;
    }

    public MsRecResponse<T> error() {
        MsRecResponse<T> response = new MsRecResponse<>();
        response.setCode(Response.FAIL);
        response.setMessage("error");
        return response;
    }

    public MsRecResponse<T> error(String message) {
        MsRecResponse<T> response = this.error();
        response.setMessage(message);
        return response;
    }

    public MsRecResponse<T> error(int code, String message) {
        MsRecResponse<T> response = this.error(message);
        response.setCode(code);
        return response;
    }


}
