package com.xforceplus.phoenix.recog.api.model;


import lombok.Data;

import java.math.BigDecimal;
/**
 * @author chong
 */
@Data
public class RecVerifyRequest {
    /**
     * rec_file表id
     * 表 : rec_invoice
     * 对应字段 : FILE_ID
     */
    private Long InvoiceId;


    /**
     * 增值税专用发票s,增值税普通发票c,增值税电子普通发票ce,增值税普通发票（卷票）ju ,通行费
     * 表 : rec_invoice
     * 对应字段 : INVOICE_TYPE
     */
    private String invoiceType;

    /**
     * 发票代码
     * 表 : rec_invoice
     * 对应字段 : INVOICE_CODE
     */
    private String invoiceCode;


    /**
     * 发票号码
     * 表 : rec_invoice
     * 对应字段 : INVOICE_NO
     */
    private String invoiceNo;


    /**
     * 销方公司id
     * 表 : rec_invoice
     * 对应字段 : SELLER_ID
     */
    private Long sellerId;

    /**
     * 销方纳税人识别号/身份证号
     * 表 : rec_invoice
     * 对应字段 : SELLER_TAX_NO
     */
    private String sellerTaxNo;

    /**
     * 销方名称
     * 表 : rec_invoice
     * 对应字段 : SELLER_NAME
     */
    private String sellerName;

    /**
     * 销方地址、电话
     * 表 : rec_invoice
     * 对应字段 : SELLER_ADDR_TEL
     */
    private String sellerAddrTel;

    /**
     * 销方地址
     * 表 : rec_invoice
     * 对应字段 : SELLER_ADDRESS
     */
    private String sellerAddress;

    /**
     * 销方电话
     * 表 : rec_invoice
     * 对应字段 : SELLER_TEL
     */
    private String sellerTel;

    /**
     * 销方开户行及账号
     * 表 : rec_invoice
     * 对应字段 : SELLER_BANK_INFO
     */
    private String sellerBankNameAccount;

    /**
     * 购方公司id
     * 表 : rec_invoice
     * 对应字段 : PURCHASER_ID
     */
    private Long purchaserId;

    /**
     * 购方纳税人识别号
     * 表 : rec_invoice
     * 对应字段 : PURCHASER_TAX_NO
     */
    private String purchaserTaxNo;

    /**
     * 购方名称
     * 表 : rec_invoice
     * 对应字段 : PURCHASER_NAME
     */
    private String purchaserName;

    /**
     * 购方地址、电话
     * 表 : rec_invoice
     * 对应字段 : PURCHASER_ADDR_TEL
     */
    private String purchaserAddrTel;

    /**
     * 购方地址
     * 表 : rec_invoice
     * 对应字段 : PURCHASER_ADDRESS
     */
    private String purchaserAddress;

    /**
     * 购方电话
     * 表 : rec_invoice
     * 对应字段 : PURCHASER_TEL
     */
    private String purchaserTel;

    /**
     * 购方开户行及账号
     * 表 : rec_invoice
     * 对应字段 : PURCHASER_BANK_INFO
     */
    private String purchaserBankNameAccount;

    /**
     * 税率
     * 表 : rec_invoice
     * 对应字段 : TAX_RATE
     */
    private String taxRate;

    /**
     * 税额
     * 表 : rec_invoice
     * 对应字段 : TAX_AMOUNT
     */
    private BigDecimal taxAmount;

    /**
     * 不含税金额
     * 表 : rec_invoice
     * 对应字段 : AMOUNT_WITHOUT_TAX
     */
    private BigDecimal amountWithoutTax;

    /**
     * 含税金额
     * 表 : rec_invoice
     * 对应字段 : AMOUNT_WITH_TAX
     */
    private BigDecimal amountWithTax;



    /**
     * 发票开票日期
     * 表 : rec_invoice
     * 对应字段 : PAPER_DREW_DATE
     */
    private String paperDrewDate;

    /**
     * 机器编码
     * 表 : rec_invoice
     * 对应字段 : MACHINE_CODE
     */
    private String machineCode;

    /**
     * 校验码
     * 表 : rec_invoice
     * 对应字段 : CHECK_CODE
     */
    private String checkCode;

    /**
     * 发票联次:1-发票联，2-抵扣联，9-其他
     * 表 : rec_invoice
     * 对应字段 : INVOICE_SHEET
     */
    private String invoiceSheet;



    /**
     * 验真状态 0-验真中;1--验真成功;2--验真失败,99-未查验
     * 表 : rec_invoice
     * 对应字段 : CHECK_STATUS
     */
    private Integer verifyStatus;
	 /**
     * 查验备注
     * 表 : vry_invoice
     * 对应字段 : VERIFY_REMARK
     */
    private String verifyRemark;



    /**
     * 备注
     * 表 : rec_invoice
     * 对应字段 : REMARK
     */
    private String remark;

/**
     * 收款人
     * 表 : vry_invoice
     * 对应字段 : CASHIERNAME
     */
    private String cashiername;

    /**
     * 复核人
     * 表 : vry_invoice
     * 对应字段 : CHECKERNAME
     */
    private String checkername;

    /**
     * 开票人
     * 表 : vry_invoice
     * 对应字段 : INVOICERNAME
     */
    private String invoicername;


}