package com.xforceplus.phoenix.recog.api.model.file;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author chong
 */
@Data
public class FileBasicInfoDto {
    @ApiModelProperty(value = "文件id")
    private Long id;
    /**
     * 扫描批次号,-rec_batch表id
     * 表 : rec_file
     * 对应字段 : BATCH_ID
     */
    @ApiModelProperty(value = "扫描批次号")
    private Long batchId;

    /**
     * 业务类型：1-单据，2-发票，3-附件，99-其他
     * 表 : rec_file
     * 对应字段 : BIZ_TYPE
     */
    @ApiModelProperty(value = "业务类型：1-单据，2-发票，3-附件，99-其他")
    private Byte bizType;

    /**
     * 来源：1-扫描，2-上传，3-对接接口，99-其他
     * 表 : rec_file
     * 对应字段 : SOURCE
     */
    @ApiModelProperty(value = "1-扫描，2-上传，3-对接接口，99-其他")
    private Byte source;

    /**
     * 是否需要识别：Y-需要，N-不需要
     * 表 : rec_file
     * 对应字段 : REQUIRE_OCR_FLAG
     */
    @ApiModelProperty(value = "是否需要识别：Y-需要，N-不需要")
    private String requireOcrFlag;

    /**
     * 原始文件路径
     * 表 : rec_file
     * 对应字段 : FILE_URL
     */
    @ApiModelProperty(value = "原始文件路径")
    private String fileUrl;


    /**
     * 原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF
     * 表 : rec_file
     * 对应字段 : FILE_TYPE
     */
    @ApiModelProperty(value = "原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
    private String fileType;


    /**
     * parentId
     * 表 : rec_file
     * 对应字段 : PARENT_ID
     */
    @ApiModelProperty(value = "parentId")
    private Long parentId;

    /**
     * 文件顺序
     * 表 : rec_file
     * 对应字段 : FILE_ORDER
     */
    @ApiModelProperty(value = "文件顺序")
    private Integer fileOrder;

    /**
     * 单据序列，0代表空
     * 表 : rec_file
     * 对应字段 : BILL_SEQ
     */
    @ApiModelProperty(value = "单据序列，0代表空")
    private Long billSeq;

    /**
     * 发票序列，0代表空
     * 表 : rec_file
     * 对应字段 : INVOICE_SEQ
     */
    @ApiModelProperty(value = "发票序列，0代表空")
    private Long invoiceSeq;

    /**
     * 附件序列，0代表空
     * 表 : rec_file
     * 对应字段 : ATTACHMENT_SEQ
     */
    @ApiModelProperty(value = "附件序列，0代表空")
    private Long attachmentSeq;

    /**
     * 处理状态：N-未识别I-正在识别F-识别完成
     * 表 : rec_file
     * 对应字段 : REC_STATUS
     */
    @ApiModelProperty(value = "处理状态：N-未识别I-正在识别F-识别完成")
    private String recStatus;

    /**
     * 挂接状态：N-未挂接F-已挂接
     * 表 : rec_file
     * 对应字段 : HANG_UP_STATUS
     */
    @ApiModelProperty(value = "挂接状态：N-未挂接F-已挂接")
    private String hangUpStatus;

    /**
     * 任务编号，识别任务编号
     * 表 : rec_file
     * 对应字段 : TASK_ID
     */
    @ApiModelProperty(value = "识别任务编号")
    private String taskId;


    /**
     * 已提交标志N-未提交，Y-已提交
     * 表 : rec_file
     * 对应字段 : SUBMITTED_FLAG
     */
    @ApiModelProperty(value = "已提交标志N-未提交，Y-已提交")
    private String submittedFlag;


    /**
     * 创建账号
     * 表 : rec_file
     * 对应字段 : CREATE_USER_ID
     */
    @ApiModelProperty(value = "创建账号")
    private Long createUserId;

    /**
     * 创建时间
     * 表 : rec_file
     * 对应字段 : CREATE_TIME
     */
    @ApiModelProperty(value = "创建时间,格式时间戳", example = "1537181115916")
    private Date createTime;

    /**
     * 更新账号
     * 表 : rec_file
     * 对应字段 : UPDATE_USER_ID
     */
    private Long updateUserId;

    /**
     * 更新时间
     * 表 : rec_file
     * 对应字段 : UPDATE_TIME
     */
    @ApiModelProperty(value = "更新时间,格式时间戳", example = "1537181115916")
    private Date updateTime;

    /**
     * 操作备注
     * 表 : rec_file
     * 对应字段 : REMARK
     */
    private String remark;
}
