package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.annotation.CompareField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author chong
 */
@Data
public class FileDetailDto {
    @ApiModelProperty(value = "文件id")
    private Long id;
    @ApiModelProperty(value = "扫描批次号")
    private Long batchId;
    @ApiModelProperty(value = "业务类型：1-单据，2-发票，3-附件，99-其他")
    private Integer bizType;
    @ApiModelProperty(value = "1-扫描，2-上传，3-对接接口，99-其他")
    private Integer source;
    @ApiModelProperty(value = "根组织id")
    private Long rootOrgId;
    @ApiModelProperty(value = "组织id")
    private Long orgId;
    @ApiModelProperty(value = " 商户分组名称")
    private String groupName;
    @ApiModelProperty(value = " 商户分组Code")
    private String groupCode;
    @ApiModelProperty(value = "是否需要识别：Y-需要，N-不需要")
    private String requireOcrFlag;
    @ApiModelProperty(value = "原始文件路径")
    private String fileUrl;
    @ApiModelProperty(value = "原始文件类型(扩展名)，jpg,png,pdf,jpeg")
    private String fileType;
    @ApiModelProperty(value = "处理文件路径(缩略图)")
    private String fileUrlHandle;
    @ApiModelProperty(value = "所有处理文件路径")
    private String fileUrlHandleTotal;
    @ApiModelProperty(value = "处理文件类型(扩展名)，jpg,png,pdf,jpeg")
    private String fileTypeHandle;
    @ApiModelProperty(value = "parentId,0代表空，1代表顶级parentId")
    private Long parentId;
    @ApiModelProperty(value = "文件顺序")
    private Integer fileOrder;
    @ApiModelProperty(value = "文件level")
    private Integer fileLevel;
    @ApiModelProperty(value = "单据序列，0代表空")
    private Long billSeq;
    @ApiModelProperty(value = "发票序列，0代表空")
    private Long invoiceSeq;
    @ApiModelProperty(value = "附件序列，0代表空")
    private Long attachmentSeq;
    @ApiModelProperty(value = "处理状态：N-未识别I-正在识别F-识别完成")
    private String recStatus;
    @ApiModelProperty(value = "挂接状态：N-未挂接F-已挂接")
    private String hangUpStatus;
    @ApiModelProperty(value = "识别任务编号")
    private String taskId;
    @ApiModelProperty(value = "识别开始时间")
    private Date recStartTime;
    @ApiModelProperty(value = "识别结束时间")
    private Date recEndTime;
    @ApiModelProperty(value = "提交id")
    private Long submitPimId;
    @ApiModelProperty(value = "提交时间")
    private Date submitTime;
    @ApiModelProperty(value = "已提交标志N-未提交，Y-已提交")
    private String submittedFlag;
    @ApiModelProperty(value = "创建用户名")
    private String createUser;
    @ApiModelProperty(value = "创建用户id")
    private Long createUserId;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "发票id")
    private Long invoiceId;
    @ApiModelProperty(value = "单据号")
    @CompareField
    private String billCode;
    @ApiModelProperty(value = "增值税专用发票s,增值税普通发票c,增值税电子普通发票ce,增值税普通发票（卷票）ju ,通行费增值税电子普通发票ct,机动车统一销售发票v")
    @CompareField
    private String invoiceType;
    @ApiModelProperty(value = "发票代码")
    @CompareField
    private String invoiceCode;
    @ApiModelProperty(value = "印刷发票代码")
    @CompareField
    private String invoiceCodePrn;
    @ApiModelProperty(value = "发票号码")
    @CompareField
    private String invoiceNo;
    @ApiModelProperty(value = "印刷发票号码")
    @CompareField
    private String invoiceNoPrn;
    @ApiModelProperty(value = "销方公司id")
    @CompareField
    private Long sellerId;
    @ApiModelProperty(value = "销方纳税人识别号/身份证号")
    @CompareField
    private String sellerTaxNo;
    @ApiModelProperty(value = "销方名称")
    @CompareField
    private String sellerName;
    @ApiModelProperty(value = "销方地址、电话")
    @CompareField
    private String sellerAddrTel;
    @ApiModelProperty(value = "销方地址")
    @CompareField
    private String sellerAddress;
    @ApiModelProperty(value = "销方电话")
    @CompareField
    private String sellerTel;
    @ApiModelProperty(value = "销方开户行及账号")
    @CompareField
    private String sellerBankInfo;
    @ApiModelProperty(value = "购方公司id")
    @CompareField
    private String purchaserId;
    @ApiModelProperty(value = "购方纳税人识别号")
    @CompareField
    private String purchaserTaxNo;
    @ApiModelProperty(value = "购方名称")
    @CompareField
    private String purchaserName;
    @ApiModelProperty(value = "购方地址、电话")
    @CompareField
    private String purchaserAddrTel;
    @ApiModelProperty(value = "购方地址")
    @CompareField
    private String purchaserAddress;
    @ApiModelProperty(value = "购方电话")
    @CompareField
    private String purchaserTel;
    @ApiModelProperty(value = "购方开户行及账号")
    @CompareField
    private String purchaserBankInfo;
    @ApiModelProperty(value = "税率")
    @CompareField
    private String taxRate;
    @ApiModelProperty(value = "税额")
    @CompareField
    private BigDecimal taxAmount;
    @ApiModelProperty(value = "不含税金额")
    @CompareField
    private BigDecimal amountWithoutTax;
    @ApiModelProperty(value = "含税金额")
    @CompareField
    private BigDecimal amountWithTax;
    @ApiModelProperty(value = "发票id")
    @CompareField
    private String amountWithTaxChn;
    @ApiModelProperty(value = "发票开票日期,格式yyyyMMdd", example = "20180101")
    @CompareField
    private Date paperDrewDate;
    @ApiModelProperty(value = "密文")
    @CompareField
    private String cipherText;
    @ApiModelProperty(value = "机器编码")
    @CompareField
    private String machineCode;
    @ApiModelProperty(value = "校验码")
    @CompareField
    private String checkCode;
    @ApiModelProperty(value = "发票联次:1-发票联，2-抵扣联，9-其他")
    @CompareField
    private String invoiceSheet;
    @ApiModelProperty(value = "查验ID")
    private Long checkId;
    @ApiModelProperty(value = "0-验真中;1--验真成功;2--验真失败;3-验真请求发送失败，99-未查验")
    private Integer checkStatus;
    @ApiModelProperty(value = "查验消息")
    private String checkInfo;
    @ApiModelProperty(value = "合规状态1-合规，2-不合规，0-空")
    private Integer complianceStatus;
    @ApiModelProperty(value = "合规（不合规）信息")
    private String complianceInfo;
    @ApiModelProperty(value = "匹配状态1-匹配，2-不匹配，0-空")
    private Integer matchStatus;
    @ApiModelProperty(value = "匹配信息")
    private String matchInfo;
    @ApiModelProperty(value = "发票提交返回状态1-成功，2-失败，3-提交中，0-空")
    private Integer submitStatus;
    @ApiModelProperty(value = "发票提交返回信息")
    private String submitInfo;
    @ApiModelProperty(value = "特殊发票标志")
    @CompareField
    private String specialInvoiceFlag;
    @ApiModelProperty(value = "自定义字段值1")
    @CompareField
    private String bizTag1;
    @ApiModelProperty(value = "自定义字段值2")
    @CompareField
    private String bizTag2;
    @ApiModelProperty(value = "自定义字段值3")
    @CompareField
    private String bizTag3;
    @ApiModelProperty(value = "备注")
    @CompareField
    private String remark;
    @ApiModelProperty(value = "收款人")
    @CompareField
    private String payee;
    @ApiModelProperty(value = "收款人")
    @CompareField
    private String reviewer;
    @ApiModelProperty(value = "开票人")
    @CompareField
    private String drawer;
    @ApiModelProperty(value = "重复数量")
    private Integer repeatCount;
    @ApiModelProperty(value = "机动车统一销售发票信息")
    private VehicleInfoDto vehicleInfoDto;
    @ApiModelProperty(value = "差异字段")
    private List<String> diffs = new ArrayList<>();
    @ApiModelProperty(value = "数据权限标志位0-无，1-有")
    private Integer dataPermissionFlag;
    @ApiModelProperty(value = "子文件")
    private List<FileDetailDto> subFiles = new ArrayList<>();
}
