package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 文件追加dto,文件位置全量信息
 * @author chong
 */
@Data
public class MsFileAppendRequest extends MsRecBaseRequest {
    @ApiModelProperty(value = "是否需要识别Y-是，N-否",required = true)
    private String requiredOcrFlag;
    @ApiModelProperty(value = "批次id", required = true)
    private Long batchId;
    @ApiModelProperty(value = "来源：1-扫描，2-上传，3-对接接口，99-其他",required = true)
    private Integer source;
    @ApiModelProperty(value = "组织id",required = true)
    private Long orgId;
    @ApiModelProperty(value = "文件次序",required = true)
    private Integer fileOrder;
    @ApiModelProperty(value = "文件level",required = true)
    private Integer fileLevel;
    @ApiModelProperty(value = "一级（单据、发票）序号",required = true)
    private Long billSeq;
    @ApiModelProperty(value = "发票序号",required = true)
    private Long invoiceSeq;
    @ApiModelProperty(value = "附件序号",required = true)
    private Long attaSeq;
    @ApiModelProperty(value = "业务类型")
    private Integer bizType;
    @ApiModelProperty(value = "自定义字段列表")
    private List<List<String>> tags;
    @ApiModelProperty(value = "url", required = true)
    private String fileUrl;
    @ApiModelProperty(value = "文件类型,文件扩展名")
    String fileType;
    @ApiModelProperty(value = "处理文件路径")
    private String fileUrlHandle;
    @ApiModelProperty(value = "处理文件类型(扩展名)，jpg,png,pdf,jpeg")
    private String fileTypeHandle;
    @ApiModelProperty(value = "客户端识别结果")
    String clientRecogResult;
}
